<?php
/**
 * Path test from student/ajax directory
 * Upload this to /student/ajax/ and run it from there
 */

echo "🔍 AJAX Path Test from student/ajax directory\n";
echo "=============================================\n\n";

echo "📂 Current directory (should be student/ajax): " . __DIR__ . "\n";
echo "📂 Going up 1 level: " . dirname(__DIR__) . "\n";
echo "📂 Going up 2 levels: " . dirname(dirname(__DIR__)) . "\n\n";

$basePath = dirname(dirname(__DIR__));
echo "📂 Base path for includes: $basePath\n\n";

$dbPath = $basePath . "/includes/db.php";
$aiPath = $basePath . "/includes/ai_grading_service.php";

echo "🔍 Checking AJAX file paths:\n";
echo "- Database: $dbPath => " . (file_exists($dbPath) ? "✅ EXISTS" : "❌ NOT FOUND") . "\n";
echo "- AI Service: $aiPath => " . (file_exists($aiPath) ? "✅ EXISTS" : "❌ NOT FOUND") . "\n";

// Show includes directory contents
$includesPath = $basePath . "/includes";
if (is_dir($includesPath)) {
    echo "\n📁 Files in includes directory:\n";
    $files = scandir($includesPath);
    foreach ($files as $file) {
        if ($file != '.' && $file != '..') {
            echo "  - $file\n";
        }
    }
} else {
    echo "\n❌ includes directory does not exist at: $includesPath\n";
}

if (file_exists($dbPath) && file_exists($aiPath)) {
    echo "\n🎉 SUCCESS! AJAX paths are now correct!\n";
    echo "Upload the fixed live_ai_grading.php and test AI grading.\n";
} else {
    echo "\n❌ Still need to fix paths or upload missing files.\n";
}
?>
