<?php
/**
 * Auto-generate completion certificates when students finish courses
 */
require_once __DIR__ . '/../../auth/functions.php';
requireRole('student');
require_once __DIR__ . '/../../config/db_connect.php';
require_once __DIR__ . '/../../config/certificate_hooks.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $input = json_decode(file_get_contents('php://input'), true);
        $course_id = intval($input['course_id']);
        $student_id = $_SESSION['user_id'];
        
        // Verify student has completed the course
        $completion_stmt = $conn->prepare("SELECT * FROM enrollments WHERE student_id = ? AND course_id = ? AND status = 'completed'");
        $completion_stmt->bind_param("ii", $student_id, $course_id);
        $completion_stmt->execute();
        $enrollment = $completion_stmt->get_result()->fetch_assoc();
        
        if (!$enrollment) {
            throw new Exception("Course not completed or enrollment not found");
        }
        
        // Generate completion certificate
        $result = triggerCompletionCertificate($student_id, $course_id, $conn);
        
        if ($result['success']) {
            echo json_encode([
                'success' => true,
                'message' => 'Completion certificate generated successfully!',
                'certificate' => $result['certificate']
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'error' => $result['message'] ?? 'Failed to generate certificate'
            ]);
        }
        
    } catch (Exception $e) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'error' => $e->getMessage()
        ]);
    }
}
?>
