<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);

echo "API Test Started\n";

// Test 1: Basic PHP execution
echo "Test 1: PHP execution - OK\n";

// Test 2: Check if we can handle POST
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    echo "Test 2: POST method detected - OK\n";
} else {
    echo "Test 2: Not a POST request\n";
}

// Test 3: Check JSON input
$input = file_get_contents("php://input");
echo "Test 3: JSON input length: " . strlen($input) . "\n";

if (!empty($input)) {
    $data = json_decode($input, true);
    if ($data !== null) {
        echo "Test 3: JSON parsing - OK\n";
    } else {
        echo "Test 3: JSON parsing failed\n";
    }
}

// Test 4: Try to include dependencies
echo "Test 4: Including dependencies...\n";
try {
    require_once "../../config/db_connect.php";
    echo "Test 4a: db_connect.php - OK\n";
} catch (Exception $e) {
    echo "Test 4a: db_connect.php - FAILED: " . $e->getMessage() . "\n";
}

try {
    require_once "../../config/fast_email_service.php";
    echo "Test 4b: fast_email_service.php - OK\n";
} catch (Exception $e) {
    echo "Test 4b: fast_email_service.php - FAILED: " . $e->getMessage() . "\n";
}

echo "API Test Completed\n";
?>