<?php
// A simple script to check what $currentPage is set to and print the CSS that would be included
require_once '../includes/session_start.php';
require_once '../config/db_connect.php';

// Set current page based on filename - matching what header.php does
$currentPage = pathinfo($_SERVER['PHP_SELF'], PATHINFO_FILENAME);
$cssFilePath = "../assets/css/pages/{$currentPage}.css";
$cssFileExists = file_exists($cssFilePath);

// Show what's happening behind the scenes
echo "<h2>CSS Debug Information</h2>";
echo "<p><strong>Current page value:</strong> '{$currentPage}'</p>";
echo "<p><strong>CSS file path:</strong> {$cssFilePath}</p>";
echo "<p><strong>File exists:</strong> " . ($cssFileExists ? 'Yes' : 'No') . "</p>";
echo "<p><strong>Full server path:</strong> " . realpath($cssFilePath) . "</p>";

// Check permissions
echo "<p><strong>File permissions:</strong> ";
if ($cssFileExists) {
    echo substr(sprintf('%o', fileperms($cssFilePath)), -4);
    echo " (readable: " . (is_readable($cssFilePath) ? 'Yes' : 'No') . ")";
} else {
    echo "N/A - File doesn't exist at expected path";
}
echo "</p>";

// Show all CSS files in the pages directory
echo "<h3>All CSS files in pages directory:</h3>";
echo "<ul>";
foreach (glob("../assets/css/pages/*.css") as $file) {
    echo "<li>" . basename($file) . " - " . filesize($file) . " bytes</li>";
}
echo "</ul>";
?>
