<?php
/**
 * Check Enrollments Table Structure
 * This will show us the actual column names in the enrollments table
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>📋 Enrollments Table Structure</h2>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;} .info{color:blue;} pre{background:#f5f5f5;padding:10px;border-radius:5px;}</style>";

try {
    require_once '../config/db_connect.php';
    
    // Check enrollments table structure
    echo "<h3>Enrollments Table Columns:</h3>";
    $result = $conn->query("DESCRIBE enrollments");
    if ($result) {
        $columns = [];
        echo "<table border='1' style='border-collapse:collapse; margin:10px 0;'>";
        echo "<tr><th style='padding:8px;'>Column</th><th style='padding:8px;'>Type</th><th style='padding:8px;'>Null</th><th style='padding:8px;'>Key</th><th style='padding:8px;'>Default</th></tr>";
        
        while ($row = $result->fetch_assoc()) {
            $columns[] = $row['Field'];
            echo "<tr>";
            echo "<td style='padding:8px;'>" . $row['Field'] . "</td>";
            echo "<td style='padding:8px;'>" . $row['Type'] . "</td>";
            echo "<td style='padding:8px;'>" . $row['Null'] . "</td>";
            echo "<td style='padding:8px;'>" . $row['Key'] . "</td>";
            echo "<td style='padding:8px;'>" . ($row['Default'] ?? 'NULL') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        echo "<div class='info'>Available columns: " . implode(', ', $columns) . "</div>";
        
        // Check for common date column variations
        $date_columns = array_filter($columns, function($col) {
            return stripos($col, 'date') !== false || stripos($col, 'created') !== false || stripos($col, 'enrolled') !== false;
        });
        
        if (!empty($date_columns)) {
            echo "<div class='success'>Found date columns: " . implode(', ', $date_columns) . "</div>";
        }
        
        // Sample data
        echo "<h3>Sample Enrollment Data:</h3>";
        $sample = $conn->query("SELECT * FROM enrollments LIMIT 3");
        if ($sample && $sample->num_rows > 0) {
            echo "<pre>";
            while ($row = $sample->fetch_assoc()) {
                print_r($row);
            }
            echo "</pre>";
        } else {
            echo "<div class='info'>No sample data available</div>";
        }
        
    } else {
        echo "<div class='error'>Error: " . $conn->error . "</div>";
    }
    
} catch (Exception $e) {
    echo "<div class='error'>Error: " . $e->getMessage() . "</div>";
}
?>
