<?php
// Session is started in header.php
require_once '../auth/functions.php';

// Require student role authentication - no exceptions
requireRole('student');

$output = [];

try {
    require_once '../config/db_connect.php';
    
    if ($conn) {
        // Get table structure for students table
        $query = "DESCRIBE students";
        $result = mysqli_query($conn, $query);
        
        if ($result) {
            $output[] = "== STUDENTS TABLE STRUCTURE ==";
            while ($row = mysqli_fetch_assoc($result)) {
                $output[] = "Field: " . $row['Field'] . 
                          " | Type: " . $row['Type'] . 
                          " | Null: " . $row['Null'] . 
                          " | Key: " . $row['Key'] . 
                          " | Default: " . ($row['Default'] ?? 'NULL') . 
                          " | Extra: " . $row['Extra'];
            }
        } else {
            $output[] = "Error fetching table structure: " . mysqli_error($conn);
        }
    } else {
        $output[] = "Database connection failed";
    }
} catch (Exception $e) {
    $output[] = "Exception: " . $e->getMessage();
}

// Output as plain text for debugging
header("Content-Type: text/plain");
echo implode("\n", $output);
?>
