<?php
require_once 'config/db_connect.php';

echo "<h1>Video Progress Table Structure</h1>";
echo "<style>
    body { font-family: Arial, sans-serif; margin: 20px; }
    table { width: 100%; border-collapse: collapse; margin: 10px 0; }
    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
    th { background: #e9ecef; }
    .success { color: #28a745; }
    .error { color: #dc3545; }
</style>";

if (!$conn) {
    echo "<p class='error'>❌ Database connection failed</p>";
    exit;
}

// Check if video_progress table exists
$table_check = $conn->query("SHOW TABLES LIKE 'video_progress'");

if ($table_check && $table_check->num_rows > 0) {
    echo "<p class='success'>✅ video_progress table exists</p>";
    
    // Show table structure
    echo "<h2>Table Structure:</h2>";
    $structure = $conn->query("DESCRIBE video_progress");
    if ($structure) {
        echo "<table>";
        echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        while ($row = $structure->fetch_assoc()) {
            echo "<tr>";
            foreach ($row as $value) {
                echo "<td>" . htmlspecialchars($value ?? 'NULL') . "</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // Count records
    $count_result = $conn->query("SELECT COUNT(*) as total FROM video_progress");
    $count = $count_result->fetch_assoc()['total'];
    echo "<p><strong>Total records:</strong> " . $count . "</p>";
    
    // Show sample data if any
    if ($count > 0) {
        echo "<h2>Sample Data:</h2>";
        $sample = $conn->query("SELECT * FROM video_progress LIMIT 5");
        if ($sample && $sample->num_rows > 0) {
            echo "<table>";
            $first_row = true;
            while ($row = $sample->fetch_assoc()) {
                if ($first_row) {
                    echo "<tr>";
                    foreach (array_keys($row) as $key) {
                        echo "<th>" . htmlspecialchars($key) . "</th>";
                    }
                    echo "</tr>";
                    $first_row = false;
                }
                echo "<tr>";
                foreach ($row as $value) {
                    echo "<td>" . htmlspecialchars($value ?? 'NULL') . "</td>";
                }
                echo "</tr>";
            }
            echo "</table>";
        }
    }
    
} else {
    echo "<p class='error'>❌ video_progress table does not exist</p>";
    
    // Show all tables
    echo "<h2>Available Tables:</h2>";
    $tables = $conn->query("SHOW TABLES");
    if ($tables) {
        echo "<ul>";
        while ($table = $tables->fetch_array()) {
            echo "<li>" . $table[0] . "</li>";
        }
        echo "</ul>";
    }
}

$conn->close();
?>
