<?php
/**
 * Dashboard Session Test - Debug what happens when accessing dashboard
 */

error_log('==== DASHBOARD TEST START ====');
error_log('DEBUG - Dashboard test accessed from: ' . ($_SERVER['HTTP_REFERER'] ?? 'direct'));
error_log('DEBUG - Request URI: ' . $_SERVER['REQUEST_URI']);
error_log('DEBUG - Session status before includes: ' . session_status());

// Check cookies received
error_log('DEBUG - Cookies received: ' . print_r($_COOKIE, true));

try {
    // Try to load functions.php
    error_log('DEBUG - Loading functions.php...');
    require_once '../auth/functions.php';
    error_log('DEBUG - functions.php loaded successfully');
    
    // Check session after loading functions
    error_log('DEBUG - Session ID after functions load: ' . session_id());
    error_log('DEBUG - Session status after functions load: ' . session_status());
    error_log('DEBUG - Session data after functions load: ' . print_r($_SESSION, true));
    
    // Test requireRole
    error_log('DEBUG - About to call requireRole(student)...');
    requireRole('student');
    error_log('DEBUG - requireRole passed! User is authenticated.');
    
    echo "<h1>✅ DASHBOARD ACCESS SUCCESSFUL!</h1>";
    echo "<p>Session ID: " . session_id() . "</p>";
    echo "<p>User ID: " . ($_SESSION['user_id'] ?? 'NOT SET') . "</p>";
    echo "<p>Role: " . ($_SESSION['user_role'] ?? 'NOT SET') . "</p>";
    echo "<p>Logged in: " . ($_SESSION['logged_in'] ?? 'NOT SET') . "</p>";
    
} catch (Exception $e) {
    error_log('ERROR - Dashboard test exception: ' . $e->getMessage());
    error_log('ERROR - Stack trace: ' . $e->getTraceAsString());
    echo "<h1>❌ DASHBOARD ERROR</h1>";
    echo "<p>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
} catch (Error $e) {
    error_log('FATAL ERROR - Dashboard test fatal: ' . $e->getMessage());
    error_log('FATAL ERROR - Stack trace: ' . $e->getTraceAsString());
    echo "<h1>❌ FATAL ERROR</h1>";
    echo "<p>Fatal Error: " . htmlspecialchars($e->getMessage()) . "</p>";
}

error_log('==== DASHBOARD TEST END ====');
?>
