<?php
// Use session_start.php for consistent session handling
require_once '../includes/session_start.php';
require_once '../auth/functions.php';

// Force login for testing
$_SESSION['user_id'] = 1;
$_SESSION['logged_in'] = true;
$_SESSION['is_logged_in'] = true;
$_SESSION['user_role'] = 'student';
$_SESSION['username'] = 'debuguser';

// Include the calendar page but capture its output
ob_start();
include('calendar.php');
$calendarOutput = ob_get_clean();

// Output with line numbers for easier debugging
echo "<pre>";
$lines = explode("\n", $calendarOutput);
foreach ($lines as $i => $line) {
    // Output line numbers and highlight CSS inclusion lines
    $lineNumber = $i + 1;
    $line = htmlspecialchars($line);
    
    // Highlight lines containing CSS references
    if (strpos($line, '.css') !== false) {
        echo "<mark><strong>$lineNumber: $line</strong></mark>\n";
    } else {
        echo "$lineNumber: $line\n";
    }
}
echo "</pre>";
?>
