<?php
/**
 * Debug Authentication for Certificate API
 * Test endpoint to check session and authentication status
 */

require_once '../auth/functions.php';
require_once '../config/db_connect.php';

header('Content-Type: application/json');

try {
    // Debug all session information
    $debug_info = [
        'session_id' => session_id(),
        'session_data' => $_SESSION,
        'user_id' => $_SESSION['user_id'] ?? 'NOT SET',
        'role' => $_SESSION['role'] ?? 'NOT SET',
        'user_type' => $_SESSION['user_type'] ?? 'NOT SET', 
        'user_role' => $_SESSION['user_role'] ?? 'NOT SET',
        'request_method' => $_SERVER['REQUEST_METHOD'],
        'all_session_keys' => array_keys($_SESSION ?? [])
    ];
    
    // Test authentication conditions
    $auth_checks = [
        'has_user_id' => isset($_SESSION['user_id']),
        'user_id_value' => $_SESSION['user_id'] ?? null,
        'has_role' => isset($_SESSION['role']),
        'role_value' => $_SESSION['role'] ?? null,
        'is_student_role' => ($_SESSION['role'] ?? '') === 'student',
        'authentication_would_pass' => isset($_SESSION['user_id']) && ($_SESSION['role'] ?? '') === 'student'
    ];
    
    echo json_encode([
        'success' => true,
        'debug_info' => $debug_info,
        'auth_checks' => $auth_checks,
        'message' => 'Authentication debug complete',
        'recommendations' => [
            'user_id_missing' => !isset($_SESSION['user_id']) ? 'Session missing user_id - login may be broken' : null,
            'role_missing' => !isset($_SESSION['role']) ? 'Session missing role - role assignment may be broken' : null,
            'wrong_role' => (isset($_SESSION['role']) && $_SESSION['role'] !== 'student') ? 'User role is: ' . $_SESSION['role'] . ' (expected: student)' : null
        ]
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'debug_info' => [
            'session_exists' => isset($_SESSION),
            'session_started' => session_status() === PHP_SESSION_ACTIVE
        ]
    ], JSON_PRETTY_PRINT);
}
?>
