<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Ensure user is logged in as student
requireRole('student');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $student_id = intval($_POST['student_id'] ?? ($_SESSION['user_id'] ?? 15));
    
    // Clear all progress for the student
    $delete_query = "DELETE FROM video_progress WHERE student_id = ?";
    $stmt = $conn->prepare($delete_query);
    $stmt->bind_param("i", $student_id);
    
    if ($stmt->execute()) {
        $affected_rows = $stmt->affected_rows;
        echo "✅ Cleared $affected_rows progress records for student $student_id";
    } else {
        echo "❌ Failed to clear progress: " . $conn->error;
    }
    
    $stmt->close();
} else {
    echo "❌ Invalid request method";
}
?>
