<?php
// 🔍 DIAGNOSTIC ENDPOINT - Check what lessons exist
ob_start();
error_reporting(0);
ini_set('display_errors', 0);
header('Content-Type: application/json');

try {
    if (session_status() == PHP_SESSION_NONE) {
        session_start();
    }
    
    $course_id = isset($_GET['course_id']) ? (int)$_GET['course_id'] : 0;
    
    if (!$course_id) {
        throw new Exception('No course_id provided');
    }
    
    require_once '../config/db_connect.php';
    
    if (!isset($conn) || !$conn) {
        throw new Exception('Database connection failed');
    }
    
    // Check what lessons exist for this course
    $lesson_check = $conn->prepare("
        SELECT 
            v.video_id,
            v.lesson_id,
            v.title,
            v.video_url,
            v.video_path,
            v.is_published,
            v.course_id
        FROM videos v
        WHERE v.course_id = ?
        ORDER BY v.lesson_id ASC, v.video_order ASC
    ");
    
    if (!$lesson_check) {
        throw new Exception('Query prepare failed: ' . $conn->error);
    }
    
    $lesson_check->bind_param("i", $course_id);
    
    if (!$lesson_check->execute()) {
        throw new Exception('Query execution failed: ' . $lesson_check->error);
    }
    
    $result = $lesson_check->get_result();
    $lessons = [];
    
    while ($row = $result->fetch_assoc()) {
        $lessons[] = $row;
    }
    
    $lesson_check->close();
    
    // Also check course exists
    $course_check = $conn->prepare("SELECT course_id, title FROM courses WHERE course_id = ?");
    $course_check->bind_param("i", $course_id);
    $course_check->execute();
    $course_result = $course_check->get_result();
    $course_data = $course_result->fetch_assoc();
    $course_check->close();
    
    ob_clean();
    
    echo json_encode([
        'success' => true,
        'message' => 'Diagnostic complete',
        'data' => [
            'course_id' => $course_id,
            'course_exists' => !empty($course_data),
            'course_title' => $course_data['title'] ?? 'Not found',
            'total_lessons' => count($lessons),
            'lessons' => $lessons,
            'lesson_ids_available' => array_column($lessons, 'lesson_id'),
            'published_lessons' => array_filter($lessons, function($l) { return $l['is_published'] == 1; })
        ]
    ]);
    
} catch (Exception $e) {
    ob_clean();
    echo json_encode([
        'success' => false,
        'message' => 'Diagnostic error: ' . $e->getMessage(),
        'error_details' => [
            'course_id' => $course_id ?? 'not set',
            'file' => basename(__FILE__)
        ]
    ]);
}

if (isset($conn)) {
    $conn->close();
}
ob_end_flush();
?>
