<?php
// Debug Quiz Badge Issue - Find actual video IDs and quiz locations
require_once '../config/db_connect.php';

echo "<h2>🔍 Comprehensive Quiz Badge Debug</h2>";

// 1. First, find all courses and their videos to get correct IDs
echo "<h3>1. Finding All Courses and Videos</h3>";
$courses_query = "SELECT c.course_id, c.title as course_title, v.video_id, v.title as video_title 
                  FROM courses c 
                  LEFT JOIN videos v ON c.course_id = v.course_id 
                  ORDER BY c.course_id, v.created_at";
$courses_result = $conn->query($courses_query);

$course_videos = [];
if ($courses_result && $courses_result->num_rows > 0) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%; margin-bottom: 20px;'>";
    echo "<tr><th>Course ID</th><th>Course Title</th><th>Video ID</th><th>Video Title</th></tr>";
    while($row = $courses_result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['course_id'] . "</td>";
        echo "<td>" . htmlspecialchars($row['course_title']) . "</td>";
        echo "<td>" . ($row['video_id'] ?? 'N/A') . "</td>";
        echo "<td>" . htmlspecialchars($row['video_title'] ?? 'No videos') . "</td>";
        echo "</tr>";
        
        if ($row['video_id']) {
            $course_videos[$row['course_id']][] = [
                'video_id' => $row['video_id'],
                'title' => $row['video_title']
            ];
        }
    }
    echo "</table>";
}

// 2. Find ALL quizzes and their locations
echo "<h3>2. All Quizzes in Database</h3>";
$all_quizzes_query = "SELECT q.quiz_id, q.title, q.course_id, q.video_id, q.is_published, 
                             c.title as course_title, v.title as video_title
                      FROM quizzes q
                      LEFT JOIN courses c ON q.course_id = c.course_id
                      LEFT JOIN videos v ON q.video_id = v.video_id
                      ORDER BY q.course_id, q.video_id";
$quizzes_result = $conn->query($all_quizzes_query);

if ($quizzes_result && $quizzes_result->num_rows > 0) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%; margin-bottom: 20px;'>";
    echo "<tr><th>Quiz ID</th><th>Quiz Title</th><th>Course ID</th><th>Course Title</th><th>Video ID</th><th>Video Title</th><th>Published</th></tr>";
    while($quiz = $quizzes_result->fetch_assoc()) {
        $published_color = $quiz['is_published'] ? 'green' : 'red';
        $published_text = $quiz['is_published'] ? 'YES' : 'NO';
        echo "<tr>";
        echo "<td>" . $quiz['quiz_id'] . "</td>";
        echo "<td>" . htmlspecialchars($quiz['title']) . "</td>";
        echo "<td>" . $quiz['course_id'] . "</td>";
        echo "<td>" . htmlspecialchars($quiz['course_title'] ?? 'Unknown') . "</td>";
        echo "<td>" . ($quiz['video_id'] ?? 'N/A') . "</td>";
        echo "<td>" . htmlspecialchars($quiz['video_title'] ?? 'No video') . "</td>";
        echo "<td style='color: $published_color; font-weight: bold;'>$published_text</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: red;'>❌ NO QUIZZES found in entire database!</p>";
}

// 3. Find Computer Science course specifically
echo "<h3>3. Looking for 'Computer science' Course</h3>";
$cs_search = $conn->query("SELECT course_id, title FROM courses WHERE title LIKE '%computer%' OR title LIKE '%Computer%'");
if ($cs_search && $cs_search->num_rows > 0) {
    while($cs = $cs_search->fetch_assoc()) {
        echo "<p><strong>Found:</strong> Course ID " . $cs['course_id'] . " - '" . $cs['title'] . "'</p>";
        
        // Get videos for this course
        $cs_videos = $conn->query("SELECT video_id, title FROM videos WHERE course_id = " . $cs['course_id']);
        if ($cs_videos && $cs_videos->num_rows > 0) {
            echo "<ul>";
            while($video = $cs_videos->fetch_assoc()) {
                echo "<li>Video ID: " . $video['video_id'] . " - '" . $video['title'] . "'</li>";
            }
            echo "</ul>";
        }
    }
}

// Now let's test the exact badge detection logic from course-detail.php
echo "<p>Let's test each video to find which ones have quizzes and their publication status...</p>";

// Test some common video IDs based on what we found above
$test_video_ids = [];
foreach($course_videos as $course_id => $videos) {
    foreach($videos as $video) {
        $test_video_ids[] = $video['video_id'];
    }
}

if (!empty($test_video_ids)) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%; margin-bottom: 20px;'>";
    echo "<tr><th>Video ID</th><th>Video Title</th><th>Has Quiz</th><th>Published</th><th>Badge Should Show</th></tr>";
    
    foreach($test_video_ids as $vid_id) {
        // Get video title
        $video_info = $conn->query("SELECT title FROM videos WHERE video_id = $vid_id");
        $video_title = 'Unknown';
        if ($video_info && $video_info->num_rows > 0) {
            $v_data = $video_info->fetch_assoc();
            $video_title = $v_data['title'];
        }
        
        // Check for quiz (any quiz)
        $quiz_any = $conn->query("SELECT quiz_id, is_published FROM quizzes WHERE video_id = $vid_id");
        $has_quiz = false;
        $is_published = false;
        $badge_should_show = false;
        
        if ($quiz_any && $quiz_any->num_rows > 0) {
            $has_quiz = true;
            $quiz_data = $quiz_any->fetch_assoc();
            $is_published = (bool)$quiz_data['is_published'];
            $badge_should_show = $is_published; // Badge only shows if published
        }
        
        echo "<tr>";
        echo "<td>$vid_id</td>";
        echo "<td>" . htmlspecialchars($video_title) . "</td>";
        echo "<td style='color: " . ($has_quiz ? 'green' : 'red') . ";'>" . ($has_quiz ? 'YES' : 'NO') . "</td>";
        echo "<td style='color: " . ($is_published ? 'green' : 'red') . ";'>" . ($is_published ? 'YES' : 'NO') . "</td>";
        echo "<td style='color: " . ($badge_should_show ? 'green' : 'red') . "; font-weight: bold;'>" . ($badge_should_show ? 'YES' : 'NO') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// 5. Solution and next steps
echo "<h3>5. 🛠️ Solution Based on Findings</h3>";
echo "<div style='background: #f0f8ff; padding: 15px; border-radius: 5px; margin-bottom: 20px;'>";

// Check if we found any unpublished quizzes
$unpublished_quizzes = $conn->query("SELECT COUNT(*) as count FROM quizzes WHERE is_published = 0");
$unpublished_count = 0;
if ($unpublished_quizzes) {
    $unpub_data = $unpublished_quizzes->fetch_assoc();
    $unpublished_count = $unpub_data['count'];
}

if ($unpublished_count > 0) {
    echo "<p style='color: red; font-weight: bold;'>🎯 PROBLEM IDENTIFIED: You have $unpublished_count unpublished quiz(es)</p>";
    echo "<p><strong>Solution:</strong> Publish the quizzes to make badges appear</p>";
    echo "<p><strong>Quick Fix Query:</strong> <code>UPDATE quizzes SET is_published = 1 WHERE is_published = 0</code></p>";
} else {
    echo "<p style='color: green;'>✅ All quizzes are published (if any exist)</p>";
}

echo "<p><strong>Other Options:</strong></p>";
echo "<ul>";
echo "<li><strong>Option 1:</strong> Manually publish quizzes through admin interface</li>";
echo "<li><strong>Option 2:</strong> Auto-publish quizzes on creation</li>";
echo "<li><strong>Option 3:</strong> Modify badge detection to show unpublished quizzes (not recommended)</li>";
echo "</ul>";
echo "</div>";

echo "<h3>6. 🎯 Recommendation</h3>";
echo "<div style='background: #e8f5e8; padding: 15px; border-radius: 5px;'>";
echo "<p><strong>Based on the analysis above, the most likely solution is to publish the existing quiz(zes).</strong></p>";
echo "<p>The quiz badge detection logic is working correctly - it just requires quizzes to be published before showing badges.</p>";
echo "</div>";

$conn->close();
?>
