<?php
error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE);

// Initialize session
if (session_status() === PHP_SESSION_NONE) {
    ini_set('session.save_path', '/tmp');
    @session_start();
}

echo "<h1>Session Debug Information</h1>";

echo "<h2>Current Session Data:</h2>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

echo "<h2>Session Status:</h2>";
echo "Session Status: " . session_status() . "<br>";
echo "Session ID: " . session_id() . "<br>";

if (isset($_SESSION)) {
    echo "Session exists: YES<br>";
    echo "Session variables count: " . count($_SESSION) . "<br>";
    
    foreach ($_SESSION as $key => $value) {
        echo "- $key: " . (is_array($value) ? print_r($value, true) : $value) . "<br>";
    }
} else {
    echo "Session exists: NO<br>";
}

echo "<h2>User Detection Test:</h2>";
$detected_user = null;
$detected_role = null;

// Test various session variable names
$possible_user_keys = ['user_id', 'id', 'student_id', 'userId'];
$possible_role_keys = ['role', 'user_role', 'type', 'account_type'];

foreach ($possible_user_keys as $key) {
    if (isset($_SESSION[$key])) {
        $detected_user = $_SESSION[$key];
        echo "Found user ID in \$_SESSION['$key']: $detected_user<br>";
        break;
    }
}

foreach ($possible_role_keys as $key) {
    if (isset($_SESSION[$key])) {
        $detected_role = $_SESSION[$key];
        echo "Found role in \$_SESSION['$key']: $detected_role<br>";
        break;
    }
}

if ($detected_user && $detected_role) {
    echo "<br><strong style='color: green;'>✓ User detected: ID=$detected_user, Role=$detected_role</strong><br>";
} else {
    echo "<br><strong style='color: red;'>✗ User not properly detected</strong><br>";
}

echo "<h2>Database Test:</h2>";
require_once '../config/db_connect.php';
if ($conn) {
    echo "Database connection: OK<br>";
    if ($detected_user) {
        $stmt = $conn->prepare("SELECT user_id, role, first_name, last_name FROM users WHERE user_id = ?");
        if ($stmt) {
            $stmt->bind_param("i", $detected_user);
            $stmt->execute();
            $result = $stmt->get_result();
            if ($row = $result->fetch_assoc()) {
                echo "User found in database: " . $row['first_name'] . " " . $row['last_name'] . " (Role: " . $row['role'] . ")<br>";
            } else {
                echo "User not found in database<br>";
            }
            $stmt->close();
        }
    }
} else {
    echo "Database connection: FAILED<br>";
}
?>
