<?php
require_once '../includes/session_start.php';
require_once '../auth/functions.php';
requireRole('student');
require_once '../config/db_connect.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

if (!$input || !isset($input['note_id'])) {
    echo json_encode(['success' => false, 'message' => 'Note ID required']);
    exit;
}

$note_id = (int)$input['note_id'];
$student_id = $_SESSION['user_id'];

try {
    // Verify the note belongs to the current student
    $verify_sql = "SELECT lesson_id FROM video_notes WHERE id = ? AND student_id = ?";
    $verify_stmt = $pdo->prepare($verify_sql);
    $verify_stmt->execute([$note_id, $student_id]);
    
    if (!$verify_stmt->fetchColumn()) {
        echo json_encode(['success' => false, 'message' => 'Note not found or access denied']);
        exit;
    }
    
    // Delete the note
    $delete_sql = "DELETE FROM video_notes WHERE id = ? AND student_id = ?";
    $delete_stmt = $pdo->prepare($delete_sql);
    $delete_stmt->execute([$note_id, $student_id]);
    
    if ($delete_stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => 'Note deleted successfully'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Failed to delete note'
        ]);
    }
    
} catch (PDOException $e) {
    error_log("Delete video note error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Database error occurred']);
}
?>
