<?php
// Fix Quiz Badge Issue - Link quiz to first video
require_once '../config/db_connect.php';

echo "<h2>🔧 Quiz Badge Fix - Linking Quiz to First Video</h2>";

$first_video_id = 2; // "Computer science" video
$quiz_id = 19; // "computer science next quiz"

echo "<h3>Current Status</h3>";
echo "<p><strong>Video:</strong> ID $first_video_id - 'Computer science'</p>";
echo "<p><strong>Quiz:</strong> ID $quiz_id - 'computer science next quiz'</p>";

// Check current quiz status
$quiz_check = $conn->query("SELECT quiz_id, title, video_id, is_published FROM quizzes WHERE quiz_id = $quiz_id");
if ($quiz_check && $quiz_check->num_rows > 0) {
    $quiz = $quiz_check->fetch_assoc();
    echo "<div style='border: 1px solid #ddd; padding: 10px; margin: 10px 0;'>";
    echo "<strong>Before Fix:</strong><br>";
    echo "Quiz ID: " . $quiz['quiz_id'] . "<br>";
    echo "Title: " . $quiz['title'] . "<br>";
    echo "Linked to Video: " . ($quiz['video_id'] ? $quiz['video_id'] : 'NONE') . "<br>";
    echo "Published: " . ($quiz['is_published'] ? 'YES' : 'NO') . "<br>";
    echo "</div>";
    
    // Apply the fix
    echo "<h3>🔧 Applying Fix</h3>";
    $update_query = "UPDATE quizzes SET video_id = ? WHERE quiz_id = ?";
    $update_stmt = $conn->prepare($update_query);
    
    if ($update_stmt) {
        $update_stmt->bind_param("ii", $first_video_id, $quiz_id);
        if ($update_stmt->execute()) {
            echo "<p style='color: green; font-weight: bold;'>✅ SUCCESS! Quiz linked to video successfully!</p>";
            
            // Verify the fix
            echo "<h3>✅ Verification</h3>";
            $verify_check = $conn->query("SELECT quiz_id, title, video_id FROM quizzes WHERE quiz_id = $quiz_id");
            if ($verify_check && $verify_check->num_rows > 0) {
                $updated_quiz = $verify_check->fetch_assoc();
                echo "<div style='border: 2px solid green; padding: 10px; margin: 10px 0; background: #f0fff0;'>";
                echo "<strong>After Fix:</strong><br>";
                echo "Quiz ID: " . $updated_quiz['quiz_id'] . "<br>";
                echo "Title: " . $updated_quiz['title'] . "<br>";
                echo "Linked to Video: " . $updated_quiz['video_id'] . "<br>";
                echo "</div>";
            }
            
            // Test badge detection
            echo "<h3>🎯 Badge Detection Test</h3>";
            $badge_test = $conn->prepare("SELECT quiz_id FROM quizzes WHERE video_id = ? AND is_published = 1 LIMIT 1");
            $badge_test->bind_param("i", $first_video_id);
            $badge_test->execute();
            $badge_result = $badge_test->get_result();
            
            if ($badge_result && $badge_result->num_rows > 0) {
                echo "<p style='color: green; font-weight: bold;'>🎉 QUIZ BADGE WILL NOW APPEAR ON FIRST VIDEO!</p>";
                echo "<p>The course-detail.php query now finds a published quiz for video ID $first_video_id</p>";
            } else {
                echo "<p style='color: red;'>❌ Badge still won't appear - check publication status</p>";
            }
            
        } else {
            echo "<p style='color: red;'>❌ ERROR: Failed to update quiz: " . $conn->error . "</p>";
        }
        $update_stmt->close();
    } else {
        echo "<p style='color: red;'>❌ ERROR: Failed to prepare update statement: " . $conn->error . "</p>";
    }
} else {
    echo "<p style='color: red;'>❌ ERROR: Quiz not found!</p>";
}

echo "<h3>📋 Summary</h3>";
echo "<div style='background: #e8f5e8; padding: 15px; border-radius: 5px;'>";
echo "<p><strong>What this fix does:</strong></p>";
echo "<ul>";
echo "<li>Links Quiz ID 19 ('computer science next quiz') to Video ID 2 ('Computer science')</li>";
echo "<li>Makes the quiz badge appear on the first video in the accordion</li>";
echo "<li>Maintains all existing quiz functionality</li>";
echo "</ul>";
echo "<p><strong>After running this fix, refresh your course detail page and the first video should show the quiz badge!</strong></p>";
echo "</div>";

$conn->close();
?>
