<?php
/**
 * 🏆 GET COMPLETED LESSONS ENDPOINT
 * Returns list of completed lesson IDs for current user
 */

require_once '../includes/config.php';
require_once '../includes/session.php';

header('Content-Type: application/json');

try {
    // Check if user is logged in
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['success' => false, 'message' => 'User not logged in']);
        exit;
    }
    
    $user_id = $_SESSION['user_id'];
    
    // Get completed lessons from user_video_completions table
    $stmt = $conn->prepare("
        SELECT DISTINCT video_id 
        FROM user_video_completions 
        WHERE user_id = ? AND completion_percentage >= 90.00
        ORDER BY video_id ASC
    ");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $completed_lessons = [];
    while ($row = $result->fetch_assoc()) {
        $completed_lessons[] = (int)$row['video_id'];
    }
    
    $stmt->close();
    
    echo json_encode([
        'success' => true,
        'completed_lessons' => $completed_lessons,
        'count' => count($completed_lessons)
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
