/**
 * Course Detail YouTube Integration
 * Real YouTube API integration for video progress tracking
 * NO DEMO CODE - Production Ready
 */

// Global YouTube API integration
function initializeProgressTracker() {
    console.log('🎬 YOUTUBE PROGRESS TRACKER: Initializing...');
    
    // This function is now called from inline scripts
    // The actual tracking is handled by the Master Video System
    if (window.MasterVideoSystem && window.MasterVideoSystem.instance) {
        console.log('✅ YOUTUBE PROGRESS TRACKER: Master Video System available');
        return true;
    } else {
        console.log('⚠️ YOUTUBE PROGRESS TRACKER: Master Video System not yet available');
        return false;
    }
}

// YouTube API Ready Handler
function onYouTubeIframeAPIReady() {
    console.log('🎬 YOUTUBE API: iframe API ready');
    window.youTubeAPIReady = true;
    
    // Notify Master Video System that YouTube API is ready
    if (window.MasterVideoSystem && window.MasterVideoSystem.instance) {
        window.MasterVideoSystem.instance.onYouTubeAPIReady();
    }
}

// Export functions globally
window.initializeProgressTracker = initializeProgressTracker;
window.onYouTubeIframeAPIReady = onYouTubeIframeAPIReady;

console.log('✅ COURSE-DETAIL-YOUTUBE: Loaded successfully');
