<?php
// Setup script to create the video_notes table
require_once 'config/db_connect.php';

try {
    // Create video_notes table
    $create_table_sql = "CREATE TABLE IF NOT EXISTS video_notes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        student_id INT NOT NULL,
        lesson_id INT NOT NULL,
        timestamp INT NOT NULL,
        formatted_time VARCHAR(20),
        note TEXT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_student_lesson (student_id, lesson_id),
        INDEX idx_timestamp (timestamp)
    )";
    
    $pdo->exec($create_table_sql);
    
    echo "✅ Video notes table created successfully!\n";
    echo "Table structure:\n";
    
    // Show table structure
    $describe_sql = "DESCRIBE video_notes";
    $result = $pdo->query($describe_sql);
    
    echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        echo "<tr>";
        foreach ($row as $value) {
            echo "<td>" . htmlspecialchars($value ?? '') . "</td>";
        }
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<p>✅ Video notes table is ready to use!</p>";
    
} catch (PDOException $e) {
    echo "❌ Error creating video_notes table: " . $e->getMessage() . "\n";
    echo "Error details: " . $e->getFile() . " on line " . $e->getLine() . "\n";
}
?>
