<?php
/**
 * Test the Fixed API
 * Simple test to verify the enrolled courses API works
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>🧪 API Test</h2>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;} .error{color:red;} .info{color:blue;} pre{background:#f5f5f5;padding:10px;border-radius:5px;overflow:auto;}</style>";

try {
    // Simulate the API call
    require_once '../auth/functions.php';
    
    if (!isset($_SESSION['user_id'])) {
        echo "<div class='error'>Please log in first</div>";
        exit;
    }
    
    $student_id = $_SESSION['user_id'];
    echo "<div class='info'>Testing for Student ID: $student_id</div>";
    
    // Make the API call
    $api_url = 'api/get_enrolled_courses.php';
    
    // Use file_get_contents to call our own API
    $context = stream_context_create([
        'http' => [
            'method' => 'GET',
            'header' => 'Cookie: ' . $_SERVER['HTTP_COOKIE'] . "\r\n"
        ]
    ]);
    
    $response = file_get_contents($api_url, false, $context);
    
    if ($response === false) {
        echo "<div class='error'>❌ API call failed</div>";
    } else {
        echo "<div class='success'>✅ API call successful</div>";
        
        $data = json_decode($response, true);
        if ($data === null) {
            echo "<div class='error'>❌ Invalid JSON response</div>";
            echo "<div class='info'>Raw response:</div>";
            echo "<pre>$response</pre>";
        } else {
            echo "<div class='success'>✅ Valid JSON response</div>";
            
            if (isset($data['success']) && $data['success']) {
                echo "<div class='success'>✅ API returned success</div>";
                echo "<div class='info'>Found " . count($data['courses']) . " courses</div>";
                
                if (!empty($data['courses'])) {
                    echo "<h3>📚 Course Data:</h3>";
                    foreach ($data['courses'] as $course) {
                        echo "<div style='border:1px solid #ddd; padding:10px; margin:10px 0; border-radius:5px;'>";
                        echo "<strong>" . htmlspecialchars($course['title']) . "</strong><br>";
                        echo "Instructor: " . htmlspecialchars($course['instructor']) . "<br>";
                        echo "Grade: " . $course['final_grade'] . "% (" . $course['letter_grade'] . ")<br>";
                        echo "Certificate: " . ($course['certificate_eligible'] ? 'Available' : 'Not Available') . "<br>";
                        echo "</div>";
                    }
                } else {
                    echo "<div class='info'>No courses found for this student</div>";
                }
                
                echo "<h3>🔍 Full API Response:</h3>";
                echo "<pre>" . json_encode($data, JSON_PRETTY_PRINT) . "</pre>";
                
            } else {
                echo "<div class='error'>❌ API returned error: " . ($data['error'] ?? 'Unknown error') . "</div>";
            }
        }
    }
    
} catch (Exception $e) {
    echo "<div class='error'>❌ Test error: " . $e->getMessage() . "</div>";
}

echo "<hr>";
echo "<h3>🎯 Next Steps:</h3>";
echo "<div class='info'>1. If API test passes, go back to your dashboard to see the courses</div>";
echo "<div class='info'>2. If there are still issues, check the Full API Response above for details</div>";
echo "<div class='info'>3. Dashboard link: <a href='dashboard.php'>Go to Dashboard</a></div>";
?>
