<?php
require_once '../config/db_connect.php';

$student_id = 15;  // Your student ID

echo "<h2>🧪 Testing Corrected Quiz Query</h2>";

// Test the exact corrected query
$quizzes_query = "
    SELECT 
        q.quiz_id,
        q.title,
        q.course_id,
        c.title as course_title,
        u.first_name,
        u.last_name,
        q.is_published
    FROM quizzes q
    JOIN courses c ON q.course_id = c.course_id
    JOIN users u ON c.teacher_id = u.user_id
    JOIN enrollments e ON c.course_id = e.course_id AND e.student_id = ?
    WHERE q.is_published = 1
    ORDER BY q.created_at DESC
";

echo "<p><strong>Testing Query for Student ID $student_id:</strong></p>";
echo "<pre>" . $quizzes_query . "</pre>";

$stmt = $conn->prepare($quizzes_query);
$stmt->bind_param("i", $student_id);
$stmt->execute();
$result = $stmt->get_result();

if (!$result) {
    echo "<p style='color: red;'>❌ Query failed: " . $conn->error . "</p>";
} else {
    echo "<p><strong>Query Results:</strong> " . $result->num_rows . " quiz(es) found</p>";
    
    if ($result->num_rows > 0) {
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr style='background: #f0f0f0;'>";
        echo "<th>Quiz ID</th><th>Quiz Title</th><th>Course ID</th><th>Course Title</th><th>Teacher</th><th>Published</th>";
        echo "</tr>";
        
        while($quiz = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $quiz['quiz_id'] . "</td>";
            echo "<td>" . $quiz['title'] . "</td>";
            echo "<td>" . $quiz['course_id'] . "</td>";
            echo "<td>" . $quiz['course_title'] . "</td>";
            echo "<td>" . $quiz['first_name'] . ' ' . $quiz['last_name'] . "</td>";
            echo "<td>" . ($quiz['is_published'] ? '✅ Yes' : '❌ No') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        echo "<p style='color: green;'>✅ <strong>SUCCESS!</strong> This query correctly shows only quizzes from enrolled courses.</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ <strong>NO QUIZZES FOUND</strong> in enrolled courses.</p>";
        echo "<p>This means:</p>";
        echo "<ul>";
        echo "<li>✅ Student IS enrolled in courses (Course ID 12 - Computer science)</li>";
        echo "<li>❌ But NO published quizzes exist in those enrolled courses</li>";
        echo "<li>💡 <strong>Solution:</strong> Create quizzes for Computer science course</li>";
        echo "</ul>";
    }
}

// Show what courses student is enrolled in
echo "<hr>";
echo "<h3>📚 Student's Enrolled Courses:</h3>";
$enrollment_query = "SELECT e.course_id, c.title, e.enrolled_date FROM enrollments e JOIN courses c ON e.course_id = c.course_id WHERE e.student_id = $student_id";
$enroll_result = $conn->query($enrollment_query);

if ($enroll_result && $enroll_result->num_rows > 0) {
    echo "<ul>";
    while($course = $enroll_result->fetch_assoc()) {
        echo "<li><strong>Course ID " . $course['course_id'] . ":</strong> " . $course['title'] . " (Enrolled: " . $course['enrolled_date'] . ")</li>";
    }
    echo "</ul>";
} else {
    echo "<p>No enrollments found.</p>";
}

// Show what quizzes exist in those courses
echo "<h3>📝 Quizzes in Enrolled Courses:</h3>";
$enrolled_courses_query = "SELECT DISTINCT e.course_id FROM enrollments e WHERE e.student_id = $student_id";
$courses_result = $conn->query($enrolled_courses_query);

if ($courses_result && $courses_result->num_rows > 0) {
    $course_ids = [];
    while($row = $courses_result->fetch_assoc()) {
        $course_ids[] = $row['course_id'];
    }
    
    $course_ids_str = implode(',', $course_ids);
    $quizzes_in_courses = "SELECT q.quiz_id, q.title, q.course_id, c.title as course_title, q.is_published FROM quizzes q JOIN courses c ON q.course_id = c.course_id WHERE q.course_id IN ($course_ids_str)";
    $quiz_result = $conn->query($quizzes_in_courses);
    
    if ($quiz_result && $quiz_result->num_rows > 0) {
        echo "<ul>";
        while($quiz = $quiz_result->fetch_assoc()) {
            $status = $quiz['is_published'] ? 'Published ✅' : 'Not Published ❌';
            echo "<li><strong>Quiz:</strong> " . $quiz['title'] . " (Course: " . $quiz['course_title'] . ") - $status</li>";
        }
        echo "</ul>";
    } else {
        echo "<p style='color: red;'>❌ <strong>NO QUIZZES EXIST</strong> in any of your enrolled courses!</p>";
        echo "<p><strong>This is why the quiz page is empty.</strong></p>";
    }
}

echo "<hr>";
echo "<h3>🛠️ Fix Options:</h3>";
echo "<ol>";
echo "<li><strong>Create quizzes for Computer science course (ID 12)</strong> - Recommended</li>";
echo "<li>Enroll in a course that has existing quizzes (like Technoprenuer)</li>";
echo "<li>Publish existing unpublished quizzes in Computer science course</li>";
echo "</ol>";

echo "<p><a href='all_quizzes.php'>← Back to Quiz Page</a></p>";
?>
