<?php
// Add contributes_to_final_grade column to assignments table
require_once '../config/db_connect.php';

echo "<h2>Adding Final Grade Contribution Feature</h2>";

try {
    // Check if column already exists
    $check_column = $conn->query("SHOW COLUMNS FROM assignments LIKE 'contributes_to_final_grade'");
    
    if ($check_column->num_rows == 0) {
        // Add the column
        $add_column_query = "
            ALTER TABLE assignments 
            ADD COLUMN contributes_to_final_grade TINYINT(1) DEFAULT 1 
            COMMENT 'Whether this assignment contributes to student final grade/certificate'
        ";
        
        if ($conn->query($add_column_query)) {
            echo "<p style='color: green;'>✅ Successfully added 'contributes_to_final_grade' column!</p>";
            
            // Update existing assignments to contribute to final grade by default
            $update_existing = $conn->query("UPDATE assignments SET contributes_to_final_grade = 1 WHERE contributes_to_final_grade IS NULL");
            echo "<p style='color: blue;'>✅ Updated existing assignments to contribute to final grade by default.</p>";
            
        } else {
            throw new Exception("Failed to add column: " . $conn->error);
        }
    } else {
        echo "<p style='color: orange;'>⚠️ Column 'contributes_to_final_grade' already exists!</p>";
    }
    
    // Show updated table structure
    echo "<h3>Updated Assignments Table Structure:</h3>";
    $result = $conn->query("DESCRIBE assignments");
    if ($result) {
        echo "<table border='1' style='border-collapse: collapse; margin: 10px 0; width: 100%;'>";
        echo "<tr style='background: #f0f0f0;'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Comment</th></tr>";
        while ($row = $result->fetch_assoc()) {
            $highlight = ($row['Field'] === 'contributes_to_final_grade') ? 'background-color: #ffffcc;' : '';
            echo "<tr style='{$highlight}'>";
            echo "<td><strong>{$row['Field']}</strong></td>";
            echo "<td>{$row['Type']}</td>";
            echo "<td>{$row['Null']}</td>";
            echo "<td>{$row['Key']}</td>";
            echo "<td>{$row['Default']}</td>";
            echo "<td>" . ($row['Comment'] ?? '') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    echo "<h3>Feature Benefits:</h3>";
    echo "<ul>";
    echo "<li>🎓 <strong>Formal Assessments:</strong> Assignments that count towards final certificate</li>";
    echo "<li>📚 <strong>Practice Assignments:</strong> Learning activities that don't affect final grade</li>";
    echo "<li>📊 <strong>Accurate Calculations:</strong> Only relevant assignments included in final grade computation</li>";
    echo "<li>🎯 <strong>Teacher Control:</strong> Full control over what contributes to student certification</li>";
    echo "</ul>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}
?>

<style>
body { font-family: Arial, sans-serif; max-width: 1200px; margin: 0 auto; padding: 20px; }
table { width: 100%; border-collapse: collapse; }
th, td { padding: 8px; text-align: left; border: 1px solid #ddd; }
th { background-color: #f0f0f0; }
</style>
