<?php
/**
 * Database Structure Diagnostic
 * Check if videos table exists and what its structure is
 */

require_once '../../includes/session_start.php';
require_once '../../config/db_connect.php';

header('Content-Type: application/json');

try {
    if (!$conn) {
        echo json_encode(['error' => 'Database connection failed']);
        exit;
    }

    // Check what tables exist
    $tables_query = "SHOW TABLES";
    $tables_result = $conn->query($tables_query);
    
    $tables = [];
    if ($tables_result) {
        while ($row = $tables_result->fetch_array()) {
            $tables[] = $row[0];
        }
    }

    // Check if videos table exists
    $videos_exists = in_array('videos', $tables);
    
    $response = [
        'database_connected' => true,
        'all_tables' => $tables,
        'videos_table_exists' => $videos_exists
    ];

    // If videos table exists, get its structure
    if ($videos_exists) {
        $structure_query = "DESCRIBE videos";
        $structure_result = $conn->query($structure_query);
        
        $columns = [];
        if ($structure_result) {
            while ($row = $structure_result->fetch_assoc()) {
                $columns[] = $row;
            }
        }
        $response['videos_table_structure'] = $columns;
        
        // Get sample data
        $sample_query = "SELECT * FROM videos LIMIT 3";
        $sample_result = $conn->query($sample_query);
        
        $sample_data = [];
        if ($sample_result) {
            while ($row = $sample_result->fetch_assoc()) {
                $sample_data[] = $row;
            }
        }
        $response['videos_sample_data'] = $sample_data;
    }

    echo json_encode($response, JSON_PRETTY_PRINT);

} catch (Exception $e) {
    echo json_encode([
        'error' => 'Exception: ' . $e->getMessage()
    ]);
}
?>
