<?php
/**
 * 🔐 SESSION STATUS CHECK & FIX SCRIPT
 */

session_start();
require_once __DIR__ . '/../includes/config.php';

echo "<html><head><title>🔐 Session Check</title></head><body style='font-family: monospace; padding: 20px;'>";
echo "<h1>🔐 SESSION STATUS CHECK</h1>";
echo "<hr>";

// 1. CHECK CURRENT SESSION
echo "<h2>1. 📊 CURRENT SESSION STATUS</h2>";
echo "<strong>Session ID:</strong> " . session_id() . "<br>";
echo "<strong>Session Status:</strong> " . (session_status() === PHP_SESSION_ACTIVE ? "✅ ACTIVE" : "❌ INACTIVE") . "<br><br>";

echo "<strong>Session Data:</strong><br>";
if (!empty($_SESSION)) {
    echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
    echo "<tr style='background: #f0f0f0;'><th>Key</th><th>Value</th></tr>";
    foreach ($_SESSION as $key => $value) {
        echo "<tr>";
        echo "<td><strong>$key</strong></td>";
        echo "<td>" . (is_array($value) ? print_r($value, true) : $value) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<span style='color: red; font-weight: bold;'>❌ SESSION IS EMPTY!</span><br>";
}

echo "<hr>";

// 2. CHECK AUTHENTICATION REQUIREMENTS
echo "<h2>2. 🔍 AUTHENTICATION CHECK</h2>";
$user_id = $_SESSION['user_id'] ?? null;
$user_role = $_SESSION['user_role'] ?? null;

echo "<strong>User ID:</strong> " . ($user_id ? "✅ $user_id" : "❌ NOT SET") . "<br>";
echo "<strong>User Role:</strong> " . ($user_role ? "✅ $user_role" : "❌ NOT SET") . "<br>";
echo "<strong>Is Teacher:</strong> " . ($user_role === 'teacher' ? "✅ YES" : "❌ NO") . "<br>";

if ($user_id && $user_role === 'teacher') {
    echo "<p style='color: green; font-weight: bold;'>✅ AUTHENTICATION IS VALID - Video upload should work!</p>";
} else {
    echo "<p style='color: red; font-weight: bold;'>❌ AUTHENTICATION FAILED - This is why video upload redirects!</p>";
}

echo "<hr>";

// 3. EMERGENCY LOGIN OPTION
echo "<h2>3. 🚨 EMERGENCY SESSION FIX</h2>";
echo "<p>If your session is broken, you can temporarily fix it for testing:</p>";

echo "<form method='POST' style='background: #fff3cd; padding: 15px; border-radius: 5px; border: 1px solid #ffc107;'>";
echo "<h3>⚠️ EMERGENCY SESSION RESTORE</h3>";
echo "<p style='color: #856404;'>This will create a temporary teacher session for testing video upload.</p>";
echo "<input type='hidden' name='emergency_login' value='1'>";
echo "<button type='submit' style='padding: 10px 20px; background: #ffc107; color: #212529; border: none; border-radius: 3px; font-weight: bold;'>🚨 Create Emergency Teacher Session</button>";
echo "</form>";

// Process emergency login
if ($_POST && isset($_POST['emergency_login'])) {
    echo "<h3>🔄 CREATING EMERGENCY SESSION:</h3>";
    
    $_SESSION['user_id'] = 999;
    $_SESSION['user_role'] = 'teacher';
    $_SESSION['username'] = 'emergency_teacher';
    $_SESSION['first_name'] = 'Emergency';
    $_SESSION['last_name'] = 'Teacher';
    $_SESSION['email'] = 'emergency@example.com';
    
    echo "<p style='color: green; font-weight: bold;'>✅ EMERGENCY SESSION CREATED!</p>";
    echo "<strong>Session Data:</strong><br>";
    echo "<pre>";
    print_r($_SESSION);
    echo "</pre>";
    
    echo "<p style='background: #d4edda; padding: 10px; border-radius: 5px; color: #155724;'>";
    echo "🎉 <strong>Emergency session is now active!</strong><br>";
    echo "You can now try the video upload again. It should work!";
    echo "</p>";
}

echo "<hr>";

// 4. CHECK DATABASE CONNECTION
echo "<h2>4. 🗄️ DATABASE CONNECTION CHECK</h2>";
if (isset($conn)) {
    if ($conn->connect_error) {
        echo "<strong>Database:</strong> ❌ <span style='color: red;'>CONNECTION FAILED - " . $conn->connect_error . "</span><br>";
    } else {
        echo "<strong>Database:</strong> ✅ <span style='color: green;'>CONNECTED</span><br>";
        
        // Check if emergency teacher exists in database
        $result = $conn->query("SELECT * FROM users WHERE user_id = 999 LIMIT 1");
        if ($result && $result->num_rows > 0) {
            echo "<strong>Emergency Teacher (ID 999):</strong> ✅ <span style='color: green;'>EXISTS IN DATABASE</span><br>";
        } else {
            echo "<strong>Emergency Teacher (ID 999):</strong> ⚠️ <span style='color: orange;'>NOT IN DATABASE (but will work for testing)</span><br>";
        }
    }
} else {
    echo "<strong>Database:</strong> ❌ <span style='color: red;'>NOT CONFIGURED</span><br>";
}

echo "<hr>";

// 5. NEXT STEPS
echo "<h2>5. 🎯 NEXT STEPS</h2>";
if ($user_id && $user_role === 'teacher') {
    echo "<p style='color: green;'>✅ Your session is working! Video upload should succeed now.</p>";
    echo "<a href='upload-video.php' style='display: inline-block; padding: 10px 20px; background: #28a745; color: white; text-decoration: none; border-radius: 3px;'>🎬 Try Video Upload Again</a>";
} else {
    echo "<p style='color: red;'>❌ You need to fix your session first:</p>";
    echo "<ol>";
    echo "<li><strong>Option 1:</strong> Use the 'Emergency Session' button above for immediate testing</li>";
    echo "<li><strong>Option 2:</strong> Log out and log back in properly</li>";
    echo "<li><strong>Option 3:</strong> Clear browser cookies and log in again</li>";
    echo "</ol>";
    
    echo "<div style='margin: 20px 0;'>";
    echo "<a href='../auth/logout.php' style='display: inline-block; padding: 10px 20px; background: #dc3545; color: white; text-decoration: none; border-radius: 3px; margin-right: 10px;'>🚪 Logout</a>";
    echo "<a href='../auth/login.php' style='display: inline-block; padding: 10px 20px; background: #007bff; color: white; text-decoration: none; border-radius: 3px;'>🔐 Login</a>";
    echo "</div>";
}

echo "<br><br>";
echo "<a href='debug-video-upload.php' style='display: inline-block; padding: 10px 20px; background: #17a2b8; color: white; text-decoration: none; border-radius: 3px; margin-right: 10px;'>🔍 Back to Debug</a>";
echo "<a href='upload-video.php' style='display: inline-block; padding: 10px 20px; background: #28a745; color: white; text-decoration: none; border-radius: 3px;'>🎬 Try Upload</a>";

echo "</body></html>";
?>
