<?php
require_once '../config/db_connect.php';

// Check if videos table exists
$result = $conn->query("SHOW TABLES LIKE 'videos'");
if($result->num_rows > 0) {
    echo "Videos table exists<br>";
    
    // Check if thumbnail column exists
    $result = $conn->query("SHOW COLUMNS FROM videos LIKE 'thumbnail'");
    if($result->num_rows === 0) {
        // Add thumbnail column if it doesn't exist
        $sql = "ALTER TABLE videos ADD COLUMN thumbnail VARCHAR(255) DEFAULT NULL AFTER duration";
        if($conn->query($sql)) {
            echo "<strong style='color:green'>SUCCESS: Added thumbnail column to videos table</strong><br>";
        } else {
            echo "<strong style='color:red'>ERROR: Failed to add thumbnail column: " . $conn->error . "</strong><br>";
        }
    } else {
        echo "Thumbnail column already exists<br>";
    }
    
    // Display all videos with thumbnails
    $videos = $conn->query("SELECT video_id, title, thumbnail FROM videos ORDER BY video_id DESC LIMIT 10");
    echo "<h3>Recent Videos:</h3>";
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>ID</th><th>Title</th><th>Thumbnail Path</th></tr>";
    
    if($videos->num_rows > 0) {
        while($video = $videos->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $video['video_id'] . "</td>";
            echo "<td>" . htmlspecialchars($video['title']) . "</td>";
            echo "<td>" . ($video['thumbnail'] ? htmlspecialchars($video['thumbnail']) : "<em>No thumbnail</em>") . "</td>";
            echo "</tr>";
        }
    } else {
        echo "<tr><td colspan='3'>No videos found</td></tr>";
    }
    
    echo "</table>";
    
} else {
    echo "<strong style='color:red'>Videos table does not exist</strong>";
}
?>
