<?php
// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Redirect if not logged in as teacher
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'teacher') {
    // Allow bypass for development
    $bypass_auth = isset($_GET['bypass_auth']) && $_GET['bypass_auth'] === 'true';
    
    if (!$bypass_auth) {
        header("Location: ../auth/login.php?redirect=" . urlencode($_SERVER['REQUEST_URI']));
        exit;
    }
}

// Get current page name for dynamic page title and active menu highlighting
$current_page = basename($_SERVER['PHP_SELF']);
$page_title = ucfirst(str_replace(['-', '.php'], [' ', ''], $current_page));

// Connect to database
require_once __DIR__ . '/../../includes/db_connection.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title ?> - Panadite Academy Teacher Portal</title>
    
    <!-- Favicon - Comprehensive Fallback Options -->
    <link rel="shortcut icon" href="/assets/images/favicon.ico" type="image/x-icon">
    <link rel="icon" href="/assets/images/favicon.ico" type="image/x-icon">
    <link rel="icon" href="/favicon.ico" type="image/x-icon">
    <link rel="icon" href="/logo.jpeg" type="image/jpeg">
    <link rel="icon" href="/assets/images/logo.jpeg" type="image/jpeg">
    
    <!-- Apple Touch Icons -->
    <link rel="apple-touch-icon" href="/logo.jpeg">
    <link rel="apple-touch-icon" href="/assets/images/logo.jpeg">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Google Fonts - Poppins (Required for Admin Design) -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    
    <!-- Boxicons -->
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    
    <!-- Complete Admin Sidebar Styling -->
    <style>
        /* CSS Variables */
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --success-color: #4caf50;
            --info-color: #2196f3;
            --warning-color: #ff9800;
            --danger-color: #f44336;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --grey-color: #adb5bd;
            --sidebar-width: 250px;
            --sidebar-collapsed-width: 70px;
            --transition-speed: 0.3s;
        }

        /* Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        body {
            min-height: 100vh;
            background: #f4f7fa;
            overflow-x: hidden;
        }

        /* Sidebar Styling - Force Override All Teacher CSS */
        .sidebar {
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            height: 100% !important;
            width: var(--sidebar-width) !important;
            background: #ffffff !important;
            z-index: 100 !important;
            transition: all var(--transition-speed) ease !important;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.05) !important;
            border: none !important;
            border-right: none !important;
        }

        .sidebar.close {
            width: var(--sidebar-collapsed-width) !important;
        }

        .sidebar .logo-details {
            height: 60px !important;
            width: 100% !important;
            display: flex !important;
            align-items: center !important;
            padding: 0 15px !important;
            border-bottom: 1px solid #f1f1f1 !important;
            background: #ffffff !important;
            margin: 0 !important;
        }

        .sidebar .logo-details .logo-img {
            max-height: 40px !important;
            margin-right: 10px !important;
            border-radius: 4px !important;
        }

        .sidebar .logo-details .logo-name {
            font-size: 18px !important;
            color: var(--primary-color) !important;
            font-weight: 600 !important;
            transition: var(--transition-speed) !important;
            opacity: 1 !important;
        }

        .sidebar.close .logo-details .logo-name {
            opacity: 0 !important;
            pointer-events: none !important;
        }

        .sidebar .logo-details .sidebar-toggle {
            position: absolute !important;
            top: 50% !important;
            right: 10px !important;
            transform: translateY(-50%) !important;
            font-size: 22px !important;
            color: var(--grey-color) !important;
            cursor: pointer !important;
            transition: var(--transition-speed) !important;
        }

        .sidebar .nav-links {
            height: 100% !important;
            padding: 15px 0 150px 0 !important;
            overflow: auto !important;
            list-style: none !important;
            margin: 0 !important;
        }

        .sidebar .nav-links::-webkit-scrollbar {
            display: none !important;
        }

        .sidebar .nav-links li {
            position: relative !important;
            list-style: none !important;
            transition: all var(--transition-speed) ease !important;
            margin: 0 !important;
            padding: 0 !important;
        }

        .sidebar .nav-links li:hover {
            background: #f8f9fa !important;
        }

        .sidebar .nav-links li.active {
            background: #f1f8ff !important;
        }

        .sidebar .nav-links li.active a {
            color: var(--primary-color) !important;
        }

        .sidebar .nav-links li.active i {
            color: var(--primary-color) !important;
        }

        .sidebar .nav-links li a {
            height: 50px !important;
            display: flex !important;
            align-items: center !important;
            text-decoration: none !important;
            padding: 0 15px !important;
            transition: all var(--transition-speed) ease !important;
            color: var(--dark-color) !important;
            border: none !important;
            background: transparent !important;
        }

        .sidebar .nav-links li a:hover {
            color: var(--dark-color) !important;
            text-decoration: none !important;
        }

        .sidebar .nav-links li a i {
            min-width: 40px !important;
            font-size: 20px !important;
            color: var(--dark-color) !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
        }

        .sidebar .nav-links li a .link_name {
            color: var(--dark-color) !important;
            font-size: 15px !important;
            font-weight: 400 !important;
            white-space: nowrap !important;
            transition: var(--transition-speed) !important;
            opacity: 1 !important;
        }

        .sidebar.close .nav-links li a .link_name {
            opacity: 0 !important;
            pointer-events: none !important;
        }

        /* Sidebar collapsed state - like student sidebar */
        .sidebar.close {
            width: 50px !important;
            min-width: 50px !important;
            max-width: 50px !important;
            overflow: hidden !important;
        }

        .sidebar.close .logo-details {
            padding: 15px !important;
        }

        .sidebar.close .logo-details .logo_name {
            opacity: 0 !important;
            pointer-events: none !important;
        }

        .sidebar.close .logo-details .logo-img {
            width: 30px !important;
            height: 30px !important;
            margin: 0 !important;
        }

        .sidebar.close .logo-details i {
            display: none !important;
        }

        .sidebar.close .nav-links li {
            position: relative !important;
            margin: 2px 0 !important;
        }

        .sidebar.close .nav-links li a {
            padding: 12px !important;
            justify-content: center !important;
        }

        .sidebar.close .nav-links li a i {
            min-width: auto !important;
            font-size: 18px !important;
            margin: 0 !important;
        }

        /* Hover effect for collapsed sidebar */
        .sidebar.close .nav-links li:hover {
            background: #f8f9fa !important;
            border-radius: 8px !important;
            margin: 0 5px !important;
        }

        .sidebar.close .nav-links li.active {
            background: #f1f8ff !important;
            border-radius: 8px !important;
            margin: 0 5px !important;
        }

        .sidebar.close .nav-links li a .link_name {
            display: none !important;
        }

        .sidebar.close ~ .main-content {
            margin-left: 50px !important;
            width: calc(100% - 50px) !important;
        }

        .sidebar.close ~ .navbar {
            width: calc(100% - 10px) !important;
            left: 50px !important;
        }

        /* Main Content Area */
        .main-content {
            position: relative;
            min-height: 100vh;
            width: calc(100% - var(--sidebar-width));
            left: var(--sidebar-width);
            transition: all var(--transition-speed) ease;
            padding-top: 60px;
        }

        .sidebar.close ~ .main-content {
            width: calc(100% - var(--sidebar-collapsed-width));
            left: var(--sidebar-collapsed-width);
        }

        /* Airbnb Style Navbar - Exact Copy */
        .airbnb-style-navbar {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 80px;
            background: #ffffff;
            border-bottom: 1px solid #dddddd;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 40px;
            z-index: 1000;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.08);
        }

        /* Left Section - Logo */
        .airbnb-nav-left {
            display: flex;
            align-items: center;
            flex: 0 0 auto;
        }

        .panadite-logo {
            display: flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
            color: #ff385c;
        }

        .panadite-logo-icon {
            font-size: 32px;
            color: #4361ee;
        }

        .panadite-logo-text {
            font-size: 22px;
            font-weight: 600;
            color: #4361ee;
            letter-spacing: -0.025em;
        }

        /* Center Section - Multi-part Search */
        .airbnb-search-container {
            flex: 1;
            display: flex;
            justify-content: center;
            max-width: 850px;
            margin: 0 auto;
        }

        .airbnb-search-bar {
            display: flex;
            align-items: center;
            background: #ffffff;
            border: 1px solid #dddddd;
            border-radius: 40px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.08);
            transition: all 0.2s ease;
            overflow: hidden;
        }

        .airbnb-search-bar:hover {
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.12);
        }

        .search-section {
            padding: 14px 24px;
            cursor: pointer;
            transition: background-color 0.2s ease;
            position: relative;
            flex: 1;
        }

        .search-section:hover {
            background: #f7f7f7;
        }

        .search-section:first-child {
            border-radius: 40px 0 0 40px;
        }

        .search-section:last-of-type {
            border-radius: 0;
            flex: 0.8;
        }

        .search-label {
            font-size: 12px;
            font-weight: 600;
            color: #222222;
            margin-bottom: 2px;
            text-transform: uppercase;
            letter-spacing: 0.04em;
        }

        .search-input {
            border: none;
            outline: none;
            background: transparent;
            font-size: 14px;
            color: #717171;
            width: 100%;
            font-weight: 400;
        }

        .search-input::placeholder {
            color: #717171;
        }

        .search-divider {
            width: 1px;
            height: 32px;
            background: #dddddd;
        }

        .airbnb-search-btn {
            width: 48px;
            height: 48px;
            background: #ff385c;
            border: none;
            border-radius: 50%;
            color: white;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 7px;
            transition: all 0.2s ease;
        }

        .airbnb-search-btn:hover {
            background: #e31c5f;
            transform: scale(1.04);
        }

        .airbnb-search-btn i {
            font-size: 16px;
        }

        /* Right Section - Menu */
        .airbnb-nav-right {
            display: flex;
            align-items: center;
            gap: 16px;
            flex: 0 0 auto;
        }

        .create-course-link {
            font-size: 14px;
            font-weight: 600;
            color: #222222;
            text-decoration: none;
            padding: 12px 16px;
            border-radius: 22px;
            transition: all 0.2s ease;
        }

        .create-course-link:hover {
            background: #f7f7f7;
            color: #222222;
        }

        .airbnb-icon-btn {
            width: 40px;
            height: 40px;
            border: none;
            background: transparent;
            border-radius: 50%;
            cursor: pointer;
            color: #717171;
            position: relative;
            transition: all 0.2s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .airbnb-icon-btn:hover {
            background: #f7f7f7;
        }

        .notification-dot {
            position: absolute;
            top: 8px;
            right: 8px;
            background: #ff385c;
            color: white;
            font-size: 10px;
            font-weight: 600;
            min-width: 16px;
            height: 16px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .airbnb-user-menu {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 6px 6px 6px 12px;
            border: 1px solid #dddddd;
            border-radius: 21px;
            cursor: pointer;
            transition: all 0.2s ease;
            background: white;
        }

        .airbnb-user-menu:hover {
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.18);
        }

        .airbnb-user-menu i {
            color: #717171;
            font-size: 16px;
        }

        .user-avatar {
            width: 30px;
            height: 30px;
            background: #4361ee;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: 600;
        }

        /* Dropdown */
        .airbnb-dropdown {
            border: none;
            border-radius: 12px;
            box-shadow: 0 2px 16px rgba(0, 0, 0, 0.12);
            padding: 8px 0;
            margin-top: 8px;
            min-width: 240px;
            background: white;
        }

        .airbnb-dropdown .dropdown-header {
            padding: 16px;
            border-bottom: 1px solid #ebebeb;
        }

        .user-info strong {
            display: block;
            font-size: 14px;
            font-weight: 600;
            color: #222222;
            margin-bottom: 2px;
        }

        .user-info span {
            font-size: 14px;
            color: #717171;
        }

        .airbnb-dropdown .dropdown-item {
            padding: 12px 16px;
            font-size: 14px;
            color: #222222;
            text-decoration: none;
            transition: background-color 0.2s ease;
        }

        .airbnb-dropdown .dropdown-item:hover {
            background: #f7f7f7;
            color: #222222;
        }

        .airbnb-dropdown .dropdown-divider {
            border-color: #ebebeb;
            margin: 8px 0;
        }

        /* Mobile Responsiveness */
        @media (max-width: 950px) {
            .airbnb-search-container {
                display: none;
            }
        }

        @media (max-width: 768px) {
            .airbnb-style-navbar {
                padding: 0 20px;
                height: 70px;
            }

            .panadite-logo-text {
                display: none;
            }

            .create-course-link {
                display: none;
            }

            .sidebar {
                left: -250px;
            }
            
            .sidebar.close {
                left: 0;
            }
            
            .main-content {
                width: 100% !important;
                margin-left: 0 !important;
            }
        }

        @media (max-width: 480px) {
            .airbnb-style-navbar {
                padding: 0 16px;
            }
        }

        /* Main content positioning for Airbnb navbar */
        .main-content {
            position: relative !important;
            min-height: 100vh !important;
            width: calc(100% - 250px) !important;
            margin-left: 250px !important;
            padding-top: 90px !important;
            transition: all 0.3s ease !important;
        }

        .sidebar.close ~ .main-content {
            width: calc(100% - var(--sidebar-collapsed-width)) !important;
            margin-left: var(--sidebar-collapsed-width) !important;
        }
    </style>

    <!-- Sidebar Toggle JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log('DOM loaded, initializing sidebar toggle...');
            
            const sidebar = document.querySelector('.sidebar');
            const sidebarToggle = document.querySelector('.sidebar-toggle-mobile');
            const mainContent = document.querySelector('.main-content');
            const navbar = document.querySelector('.navbar');
            
            console.log('Elements found:', {
                sidebar: !!sidebar,
                sidebarToggle: !!sidebarToggle,
                mainContent: !!mainContent,
                navbar: !!navbar
            });
            
            if (sidebarToggle && sidebar) {
                sidebarToggle.addEventListener('click', function(e) {
                    e.preventDefault();
                    console.log('Toggle button clicked');
                    
                    sidebar.classList.toggle('close');
                    console.log('Sidebar has close class:', sidebar.classList.contains('close'));
                    
                    // Force immediate style update
                    if (sidebar.classList.contains('close')) {
                        sidebar.style.width = '50px';
                        if (mainContent) {
                            mainContent.style.marginLeft = '50px';
                        }
                        if (navbar) {
                            navbar.style.width = 'calc(100% - 50px)';
                        }
                        console.log('Sidebar collapsed');
                    } else {
                        sidebar.style.width = '250px';
                        if (mainContent) {
                            mainContent.style.marginLeft = '250px';
                        }
                        if (navbar) {
                            navbar.style.width = 'calc(100% - 250px)';
                        }
                        console.log('Sidebar expanded');
                    }
                });
                
                console.log('Toggle event listener added');
            } else {
                console.error('Required elements not found:', {
                    sidebarToggle: sidebarToggle,
                    sidebar: sidebar
                });
            }
            
            // Also try to bind to any element with bx-menu class as backup
            const menuIcons = document.querySelectorAll('.bx-menu');
            menuIcons.forEach(function(icon) {
                icon.addEventListener('click', function(e) {
                    e.preventDefault();
                    console.log('Menu icon clicked (backup handler)');
                    
                    if (sidebar) {
                        sidebar.classList.toggle('close');
                        
                        if (sidebar.classList.contains('close')) {
                            sidebar.style.width = '50px';
                            if (mainContent) mainContent.style.marginLeft = '50px';
                            if (navbar) navbar.style.width = 'calc(100% - 50px)';
                        } else {
                            sidebar.style.width = '250px';
                            if (mainContent) mainContent.style.marginLeft = '250px';
                            if (navbar) navbar.style.width = 'calc(100% - 250px)';
                        }
                    }
                });
            });
            
            // Test function - you can call this in browser console
            window.testSidebarToggle = function() {
                if (sidebar) {
                    sidebar.classList.toggle('close');
                    console.log('Test toggle - sidebar has close class:', sidebar.classList.contains('close'));
                }
            };
        });
    </script>
    
    <!-- Force Override All Teacher Styles -->
    <style>
        /* Nuclear override - disable ALL existing teacher sidebar styles */
        .sidebar, .sidebar *, .sidebar *::before, .sidebar *::after {
            all: unset !important;
        }
        
        /* Rebuild sidebar from scratch with admin styling */
        .sidebar {
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            height: 100vh !important;
            width: 250px !important;
            background: #ffffff !important;
            z-index: 100 !important;
            transition: all 0.3s ease !important;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.05) !important;
            display: block !important;
            font-family: 'Poppins', sans-serif !important;
        }

        .sidebar .logo-details {
            height: 60px !important;
            width: 100% !important;
            display: flex !important;
            align-items: center !important;
            padding: 0 15px !important;
            border-bottom: 1px solid #f1f1f1 !important;
            background: #ffffff !important;
            box-sizing: border-box !important;
        }

        .sidebar .logo-details .logo-img {
            max-height: 40px !important;
            margin-right: 10px !important;
            border-radius: 4px !important;
            display: block !important;
        }

        .sidebar .logo-details .logo-name {
            font-size: 18px !important;
            color: #4361ee !important;
            font-weight: 600 !important;
            font-family: 'Poppins', sans-serif !important;
            display: block !important;
        }

        .sidebar .nav-links {
            height: calc(100% - 60px) !important;
            padding: 15px 0 !important;
            overflow: auto !important;
            list-style: none !important;
            margin: 0 !important;
            display: block !important;
        }

        .sidebar .nav-links li {
            position: relative !important;
            list-style: none !important;
            display: block !important;
            margin: 0 !important;
            padding: 0 !important;
            transition: background 0.3s ease !important;
        }

        .sidebar .nav-links li:hover {
            background: #f8f9fa !important;
        }

        .sidebar .nav-links li.active {
            background: #f1f8ff !important;
        }

        .sidebar .nav-links li a {
            height: 50px !important;
            display: flex !important;
            align-items: center !important;
            text-decoration: none !important;
            padding: 0 15px !important;
            color: #212529 !important;
            font-family: 'Poppins', sans-serif !important;
            box-sizing: border-box !important;
            transition: all 0.3s ease !important;
        }

        .sidebar .nav-links li.active a {
            color: #4361ee !important;
        }

        .sidebar .nav-links li a i {
            min-width: 40px !important;
            font-size: 20px !important;
            color: #212529 !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
        }

        .sidebar .nav-links li.active a i {
            color: #4361ee !important;
        }

        .sidebar .nav-links li a .link_name {
            color: #212529 !important;
            font-size: 15px !important;
            font-weight: 400 !important;
            font-family: 'Poppins', sans-serif !important;
            white-space: nowrap !important;
            display: block !important;
        }

        .sidebar .nav-links li.active a .link_name {
            color: #4361ee !important;
        }

        /* Main content positioning for Panadite navbar */
        .main-content {
            position: relative !important;
            min-height: 100vh !important;
            width: calc(100% - 250px) !important;
            margin-left: 250px !important;
            padding-top: 70px !important;
            transition: all 0.3s ease !important;
        }

        .sidebar.close ~ .main-content {
            width: calc(100% - var(--sidebar-collapsed-width)) !important;
            margin-left: var(--sidebar-collapsed-width) !important;
        }
    </style>
    
    <!-- Page-specific CSS and JS -->
    <?php if ($current_page === 'dashboard.php'): ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
    <?php elseif ($current_page === 'analytics.php'): ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/apexcharts@3.35.0/dist/apexcharts.css">
    <?php endif; ?>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <!-- Sidebar Component -->
    <?php include_once __DIR__ . '/sidebar.php'; ?>
    
    <!-- Main Content -->
    <section class="main-content">
        <!-- Navbar Component -->
        <?php include_once __DIR__ . '/navbar.php'; ?>
        
        <!-- Dashboard Content -->
        <div class="dashboard-content">
            <!-- Page Content Container -->
            <div class="container-fluid">
                <!-- Content will go here -->
