<?php
// Get current user information
$user_name = isset($_SESSION['first_name']) ? $_SESSION['first_name'] . ' ' . $_SESSION['last_name'] : 'Teacher';
$user_initials = isset($_SESSION['first_name']) ? substr($_SESSION['first_name'], 0, 1) . substr($_SESSION['last_name'], 0, 1) : 'T';

// Get user profile picture from database
$user_profile_picture = null;
if (isset($_SESSION['user_id'])) {
    require_once __DIR__ . '/../../config/db_connect.php';
    
    $profile_query = "SELECT profile_picture FROM users WHERE user_id = ?";
    $profile_stmt = $conn->prepare($profile_query);
    $profile_stmt->bind_param("i", $_SESSION['user_id']);
    $profile_stmt->execute();
    $profile_result = $profile_stmt->get_result();
    
    if ($profile_data = $profile_result->fetch_assoc()) {
        $user_profile_picture = $profile_data['profile_picture'];
    }
}
?>
<nav class="airbnb-style-navbar">
    <!-- Left Section - Logo -->
    <div class="airbnb-nav-left">
        <!-- Sidebar Toggle Button -->
        <button class="sidebar-toggle-btn">
            <i class='bx bx-menu'></i>
        </button>
        
        <div class="panadite-logo">
            <img src="../assets/images/logo.jpeg" alt="Panadite Academy" class="panadite-logo-image">
        </div>
    </div>
    
    <!-- Right Section - Menu -->
    <div class="airbnb-nav-right">
        <!-- Create Course Button -->
        <a href="create-course.php" class="create-course-btn">
            <i class='bx bx-plus-circle'></i>
            Create Course
        </a>
        
        <!-- Notifications -->
        <button class="nav-icon-btn" onclick="toggleNotifications()" title="Notifications">
            <i class='bx bx-bell'></i>
            <?php
            // Get dynamic notification count
            $notification_count = 0;
            try {
                if (file_exists(__DIR__ . '/../../includes/NotificationService.php') && isset($conn)) {
                    require_once __DIR__ . '/../../includes/NotificationService.php';
                    $notificationService = new NotificationService($conn);
                    
                    // Use session user_id if available, otherwise fallback to 1 (for testing)
                    $user_id = $_SESSION['user_id'] ?? 1;
                    $notification_count = $notificationService->getUnreadCount($user_id);
                    
                    // Debug output
                    error_log("🔔 Navbar Debug - User ID: $user_id, Count: $notification_count");
                } else {
                    error_log("🔔 Navbar Debug - Missing requirements: " . 
                        "File exists: " . (file_exists(__DIR__ . '/../../includes/NotificationService.php') ? 'Yes' : 'No') . 
                        ", Conn: " . (isset($conn) ? 'Yes' : 'No'));
                }
            } catch (Exception $e) {
                // Fallback to 0 if there's an error
                error_log("Navbar notification count error: " . $e->getMessage());
                $notification_count = 0;
            }
            ?>
            <span class="notification-badge amber-badge" <?= $notification_count > 0 ? '' : 'style="display: none;"' ?>><?= $notification_count ?></span>
        </button>
        
        <!-- User Menu -->
        <div class="dropdown">
            <div class="airbnb-user-menu dropdown-toggle" data-bs-toggle="dropdown">
                <i class='bx bx-menu'></i>
                <div class="user-avatar">
                    <?php if (!empty($user_profile_picture) && file_exists(__DIR__ . '/../../' . $user_profile_picture)): ?>
                        <img src="../<?= htmlspecialchars($user_profile_picture) ?>" alt="<?= htmlspecialchars($user_name) ?>" class="navbar-profile-image">
                    <?php else: ?>
                        <div class="navbar-initials-avatar"><?= $user_initials ?></div>
                    <?php endif; ?>
                </div>
            </div>
            <ul class="dropdown-menu dropdown-menu-end airbnb-dropdown">
                <li class="dropdown-header">
                    <div class="user-info">
                        <strong><?= $user_name ?></strong>
                        <span>Teacher Account</span>
                    </div>
                </li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="dashboard.php">Dashboard</a></li>
                <li><a class="dropdown-item" href="profile.php">Account</a></li>
                <li><a class="dropdown-item" href="analytics.php">Analytics</a></li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="/auth/logout.php">Log out</a></li>
            </ul>
        </div>
    </div>
</nav>

<style>
/* Navbar Profile Image Styles */
.navbar-profile-image {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 50%;
}

.navbar-initials-avatar {
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #2563eb, #7c3aed);
    color: white;
    font-weight: 600;
    font-size: 14px;
    border-radius: 50%;
}

/* Ensure user-avatar container maintains proper size */
.user-avatar {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Enhanced Navbar Button Styles */
.create-course-btn {
    display: flex;
    align-items: center;
    gap: 8px;
    background: linear-gradient(135deg, #2563eb, #1d4ed8);
    color: white;
    padding: 10px 16px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    font-size: 14px;
    transition: all 0.2s ease;
    border: none;
    box-shadow: 0 2px 4px rgba(37, 99, 235, 0.2);
}

.create-course-btn:hover {
    background: linear-gradient(135deg, #1d4ed8, #1e40af);
    color: white;
    text-decoration: none;
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(37, 99, 235, 0.3);
}

.create-course-btn i {
    font-size: 16px;
}

/* Navigation Icon Buttons */
.nav-icon-btn {
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border: none;
    background: #f8fafc;
    border-radius: 50%;
    cursor: pointer;
    transition: all 0.2s ease;
    color: #64748b;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
}

.nav-icon-btn:hover {
    background: #e2e8f0;
    color: #2563eb;
    transform: translateY(-1px);
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
}

.nav-icon-btn i {
    font-size: 18px;
}

/* Amber Notification Badges */
.notification-badge {
    position: absolute;
    top: -2px;
    right: -2px;
    min-width: 18px;
    height: 18px;
    border-radius: 9px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 11px;
    font-weight: 600;
    color: white;
    line-height: 1;
    padding: 0 4px;
}

.amber-badge {
    background: linear-gradient(135deg, #f59e0b, #d97706);
    box-shadow: 0 2px 4px rgba(245, 158, 11, 0.3);
}

/* Navbar Right Section Layout */
.airbnb-nav-right {
    display: flex;
    align-items: center;
    gap: 12px;
}

/* Mobile Responsiveness */
@media (max-width: 768px) {
    /* Hide Create Course button completely on mobile */
    .create-course-btn {
        display: none;
    }
    
    /* Adjust navbar spacing for mobile */
    .airbnb-nav-right {
        gap: 8px;
    }
    
    /* Make icon buttons slightly smaller on mobile */
    .nav-icon-btn {
        width: 36px;
        height: 36px;
    }
    
    /* Adjust notification badge positioning for smaller buttons */
    .notification-badge {
        top: -3px;
        right: -3px;
        min-width: 16px;
        height: 16px;
        font-size: 10px;
    }
}
</style>

<script>
function toggleMessages() {
    // Navigate to messages page
    console.log('Navigating to messages page');
    window.location.href = 'messages.php';
}

function toggleNotifications() {
    // Navigate to notifications page
    console.log('Navigating to notifications page');
    window.location.href = 'notifications.php';
}
</script>
