<?php
// Basic diagnostic file - no includes, no complex code
echo '<html><head><title>PHP Test</title></head><body>';
echo '<h1>PHP Test Page</h1>';

// Show PHP version and basic info
echo '<h2>PHP Information</h2>';
echo '<p>PHP Version: ' . phpversion() . '</p>';

// Start a fresh session
session_start();

// Display session info
echo '<h2>Session Information</h2>';
echo '<p>Session ID: ' . session_id() . '</p>';
echo '<pre>';
print_r($_SESSION);
echo '</pre>';

// Check if we can access database
echo '<h2>Database Connection Test</h2>';
try {
    $conn = new mysqli('localhost', 'your_db_user', 'your_password', 'your_database');
    if ($conn->connect_error) {
        echo '<p style="color:red">Connection failed: ' . $conn->connect_error . '</p>';
    } else {
        echo '<p style="color:green">Database connection successful!</p>';
        $conn->close();
    }
} catch (Exception $e) {
    echo '<p style="color:red">Error: ' . $e->getMessage() . '</p>';
}

// Environment information
echo '<h2>Environment</h2>';
echo '<p>Server: ' . $_SERVER['SERVER_SOFTWARE'] . '</p>';
echo '<p>Protocol: ' . $_SERVER['SERVER_PROTOCOL'] . '</p>';
echo '<p>Document Root: ' . $_SERVER['DOCUMENT_ROOT'] . '</p>';
echo '<p>Current Script: ' . $_SERVER['SCRIPT_FILENAME'] . '</p>';

echo '</body></html>';
