<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Centralized session management
require_once "../includes/session_start.php";
require_once "../config/db_connect.php";
require_once "../includes/functions.php";
require_once "../auth/functions.php";

// Check if user is logged in and is a teacher
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'teacher') {
    header("Location: ../login.php");
    exit;
}

$teacher_id = $_SESSION['user_id'];
$teacher = get_teacher($conn, $teacher_id);

// Get the courses taught by this teacher for the dropdown
$courses = [];
$stmt = $conn->prepare("SELECT course_id, title FROM courses WHERE teacher_id = ?");
$stmt->bind_param("i", $teacher_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $courses[] = $row;
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Quiz - Panadite Academy</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4e73df;
            --primary-light: #eaeffd;
            --secondary: #858796;
            --success: #1cc88a;
            --danger: #e74a3b;
            --warning: #f6c23e;
            --info: #36b9cc;
            --dark: #5a5c69;
            --sidebar-width: 250px;
        }
        
        body {
            font-family: 'Nunito', sans-serif;
            background-color: #f8f9fc;
        }
        
        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: var(--sidebar-width);
            background-color: white;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
            position: fixed;
            top: 0;
            bottom: 0;
            left: 0;
            z-index: 1000;
            padding: 0;
            overflow-y: auto;
            transition: all 0.3s ease;
        }
        
        .content-wrapper {
            margin-left: var(--sidebar-width);
            width: calc(100% - var(--sidebar-width));
            max-width: 100%;
            transition: all 0.3s ease;
            padding: 20px;
        }
        
        .sidebar-header {
            padding: 15px 20px;
            display: flex;
            align-items: center;
            background-color: var(--primary-light);
        }
        
        .sidebar-brand {
            display: flex;
            align-items: center;
            color: var(--primary);
            font-weight: 700;
            font-size: 1.2rem;
            text-decoration: none;
        }
        
        .sidebar-brand img {
            height: 30px;
            margin-right: 10px;
        }
        
        .sidebar-nav {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        
        .sidebar-heading {
            padding: 10px 20px;
            font-weight: 700;
            font-size: 0.8rem;
            color: var(--secondary);
            margin-top: 20px;
        }
        
        .nav-item {
            margin-bottom: 5px;
        }
        
        .nav-link {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #495057;
            text-decoration: none;
            border-radius: 5px;
            margin: 0 10px;
            transition: all 0.2s ease;
        }
        
        .nav-link i {
            margin-right: 10px;
            font-size: 1.1rem;
            width: 20px;
            text-align: center;
            color: #555;
        }
        
        .nav-link:hover {
            background-color: rgba(39, 107, 228, 0.1);
            color: var(--primary);
        }
        
        .nav-link:hover i {
            color: var(--primary);
        }
        
        .nav-link.active {
            background-color: var(--primary-light);
            color: var(--primary);
            font-weight: 500;
            box-shadow: 0 2px 5px rgba(39, 107, 228, 0.1);
        }
        
        .nav-link.active i {
            color: var(--primary);
        }
        
        .dashboard-navbar {
            background-color: #fff;
            box-shadow: 0 2px 15px rgba(0, 0, 0, 0.05);
            border-radius: 10px;
            padding: 15px 20px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <a href="../index.php" class="sidebar-brand">
                    <img src="../assets/images/logo.jpeg" alt="Panadite Academy" onerror="this.src='../assets/images/favicon.ico';">
                    <span>Panadite Academy</span>
                </a>
            </div>
            
            <ul class="sidebar-nav">
                <li class="sidebar-heading">MAIN</li>
                
                <li class="nav-item">
                    <a href="dashboard.php" class="nav-link">
                        <i class="fas fa-tachometer-alt"></i>
                        <span>Dashboard</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="courses.php" class="nav-link">
                        <i class="fas fa-graduation-cap"></i>
                        <span>Courses</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="create-course.php" class="nav-link">
                        <i class="fas fa-plus-circle"></i>
                        <span>Create Course</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="videos.php" class="nav-link">
                        <i class="fas fa-video"></i>
                        <span>Videos</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="upload-video.php" class="nav-link">
                        <i class="fas fa-cloud-upload-alt"></i>
                        <span>Upload Video</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="students.php" class="nav-link">
                        <i class="fas fa-user-graduate"></i>
                        <span>Students</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="quizzes.php" class="nav-link active">
                        <i class="fas fa-tasks"></i>
                        <span>Quizzes</span>
                    </a>
                </li>
            </ul>
        </aside>
        
        <div class="content-wrapper">
            <!-- Navbar -->
            <nav class="dashboard-navbar">
                <div class="d-flex align-items-center">
                    <button id="sidebarToggle" class="btn btn-sm btn-light me-2">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h4 class="mb-0">Create New Quiz</h4>
                </div>
                
                <div class="d-flex align-items-center">
                    <div class="dropdown">
                        <button class="btn btn-light d-flex align-items-center" data-bs-toggle="dropdown">
                            <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px; font-weight: bold;">
                                <?php echo strtoupper(substr($teacher['first_name'], 0, 1)); ?>
                            </div>
                            <span class="d-none d-md-inline"><?php echo htmlspecialchars($teacher['first_name']); ?></span>
                        </button>
                        <div class="dropdown-menu dropdown-menu-end">
                            <a href="profile.php" class="dropdown-item">
                                <i class="fas fa-user me-2"></i> Profile
                            </a>
                            <a href="settings.php" class="dropdown-item">
                                <i class="fas fa-cog me-2"></i> Settings
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="../logout.php" class="dropdown-item">
                                <i class="fas fa-sign-out-alt me-2"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
            </nav>
            
            <!-- Main Content -->
            <div class="container-fluid px-0">
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body p-4">
                        <h5 class="mb-4">Under Construction</h5>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i> The quiz creation feature is currently being set up. Check back soon!
                        </div>
                        <a href="quizzes.php" class="btn btn-primary">Back to Quizzes</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Toggle sidebar
            $('#sidebarToggle').click(function() {
                $('.sidebar').toggleClass('show');
                if ($('.sidebar').hasClass('show')) {
                    $('.content-wrapper').css('margin-left', '0');
                    $('.content-wrapper').css('width', '100%');
                } else {
                    $('.content-wrapper').css('margin-left', 'var(--sidebar-width)');
                    $('.content-wrapper').css('width', 'calc(100% - var(--sidebar-width))');
                }
            });
            
            // Handle responsive behavior
            function checkWidth() {
                if ($(window).width() < 992) {
                    $('.sidebar').removeClass('show');
                    $('.content-wrapper').css('margin-left', '0');
                    $('.content-wrapper').css('width', '100%');
                } else {
                    $('.sidebar').addClass('show');
                    $('.content-wrapper').css('margin-left', 'var(--sidebar-width)');
                    $('.content-wrapper').css('width', 'calc(100% - var(--sidebar-width))');
                }
            }
            
            // Check width on page load and resize
            checkWidth();
            $(window).resize(checkWidth);
        });
    </script>
</body>
</html>
