<?php
// This is a simple debug script to test database insertion directly
// Start session
session_start();

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection
$conn = new mysqli("localhost", "root", "", "panadite_academy");

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "<h1>Video Upload Debug Tool</h1>";
echo "<p>Testing database connection and insertion</p>";

// Session information
echo "<h2>Session Information</h2>";
echo "<p>Session active: " . (session_status() === PHP_SESSION_ACTIVE ? "Yes" : "No") . "</p>";
echo "<p>Session ID: " . session_id() . "</p>";
echo "<p>User ID in session: " . (isset($_SESSION['user_id']) ? $_SESSION['user_id'] : "Not set") . "</p>";
echo "<p>User role in session: " . (isset($_SESSION['user_role']) ? $_SESSION['user_role'] : "Not set") . "</p>";

// Database check
echo "<h2>Database Check</h2>";
$result = $conn->query("SELECT * FROM videos LIMIT 10");
if ($result) {
    echo "<p>Found " . $result->num_rows . " videos in database</p>";
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>Title</th><th>Teacher ID</th><th>Course ID</th><th>Created</th></tr>";
    
    while($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['video_id'] . "</td>";
        echo "<td>" . $row['title'] . "</td>";
        echo "<td>" . $row['teacher_id'] . "</td>";
        echo "<td>" . $row['course_id'] . "</td>";
        echo "<td>" . $row['created_at'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>Error querying videos: " . $conn->error . "</p>";
}

// Test insertion (if button is clicked)
if (isset($_POST['test_insert'])) {
    // Get the teacher_id from session
    $teacher_id = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : 0;
    
    // Test data
    $title = "Test Video " . time();
    $video_url = "test_url_" . time() . ".mp4";
    $course_id = isset($_POST['course_id']) ? (int)$_POST['course_id'] : 0;
    $description = "This is a test video inserted for debugging";
    $duration = "0:30";
    $thumbnail = null;
    
    // Echo the values for debugging
    echo "<h3>Insertion Test Values</h3>";
    echo "<p>Title: $title</p>";
    echo "<p>Video URL: $video_url</p>";
    echo "<p>Course ID: $course_id</p>";
    echo "<p>Teacher ID: $teacher_id</p>";
    echo "<p>Description: $description</p>";
    echo "<p>Duration: $duration</p>";
    
    // Direct SQL insertion
    $sql = "INSERT INTO videos (title, video_url, course_id, teacher_id, description, duration, thumbnail) 
            VALUES ('$title', '$video_url', $course_id, $teacher_id, '$description', '$duration', NULL)";
    
    echo "<p>SQL Query: " . htmlspecialchars($sql) . "</p>";
    
    if ($conn->query($sql) === TRUE) {
        $new_id = $conn->insert_id;
        echo "<p style='color:green;'>Success! Inserted new video with ID: $new_id</p>";
    } else {
        echo "<p style='color:red;'>Error: " . $conn->error . "</p>";
    }
    
    // Now verify the insertion
    $verify_sql = "SELECT * FROM videos WHERE video_id = " . $conn->insert_id;
    $verify_result = $conn->query($verify_sql);
    
    if ($verify_result && $verify_result->num_rows > 0) {
        $row = $verify_result->fetch_assoc();
        echo "<p>Verified inserted record:</p>";
        echo "<pre>";
        print_r($row);
        echo "</pre>";
    } else {
        echo "<p>Could not verify insertion. Error: " . $conn->error . "</p>";
    }
}

// Course selection for test
echo "<h2>Test Database Insertion</h2>";
echo "<form method='post'>";
echo "<p>Select course: <select name='course_id' required>";

$courses = $conn->query("SELECT course_id, title FROM courses ORDER BY title");
if ($courses && $courses->num_rows > 0) {
    while($course = $courses->fetch_assoc()) {
        echo "<option value='" . $course['course_id'] . "'>" . htmlspecialchars($course['title']) . "</option>";
    }
} else {
    echo "<option value=''>No courses found</option>";
}

echo "</select></p>";
echo "<p><input type='submit' name='test_insert' value='Test Insert Video Record'></p>";
echo "</form>";

// Database info
echo "<h2>Database Information</h2>";
echo "<p>Database Name: panadite_academy</p>";
echo "<p>Server: localhost</p>";
echo "<p>User: root</p>";

// Table structure
echo "<h2>Videos Table Structure</h2>";
$result = $conn->query("DESCRIBE videos");
if ($result) {
    echo "<table border='1'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    
    while($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . $row['Default'] . "</td>";
        echo "<td>" . $row['Extra'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>Error checking table structure: " . $conn->error . "</p>";
}

// Close the database connection
$conn->close();
?>

<p><a href="upload-video.php">Back to Upload Video</a> | <a href="videos.php">Back to Videos List</a></p>
