<?php
// Debug fix script for videos page
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Connect to database
$conn = new mysqli("localhost", "root", "", "panadite_academy");

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get current user ID from session
$current_user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 'Not logged in';

// Check if we need to fix something
$action = isset($_GET['action']) ? $_GET['action'] : '';
$video_id = isset($_GET['video_id']) ? (int)$_GET['video_id'] : 0;
$message = '';

// Handle actions
if ($action == 'fix' && $video_id > 0 && is_numeric($current_user_id)) {
    // Update video's teacher_id to match current user
    $stmt = $conn->prepare("UPDATE videos SET teacher_id = ? WHERE video_id = ?");
    $stmt->bind_param("ii", $current_user_id, $video_id);
    
    if ($stmt->execute()) {
        $message = "<div class='alert alert-success'>Success! Video ID $video_id has been assigned to your teacher account.</div>";
    } else {
        $message = "<div class='alert alert-danger'>Error updating video: " . $conn->error . "</div>";
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Video Debugging Tool</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1>Video Debug & Fix Tool</h1>
        <div class="alert alert-info">
            <p><strong>Current Teacher ID:</strong> <?php echo $current_user_id; ?></p>
        </div>
        
        <?php echo $message; ?>
        
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h3>All Videos in Database</h3>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Title</th>
                            <th>Course ID</th>
                            <th>Teacher ID</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // Get all videos
                        $result = $conn->query("SELECT v.*, c.title as course_title FROM videos v LEFT JOIN courses c ON v.course_id = c.course_id ORDER BY v.created_at DESC");
                        
                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                $teacher_match = ($row['teacher_id'] == $current_user_id) ? 'bg-success text-white' : '';
                                echo "<tr class='$teacher_match'>";
                                echo "<td>{$row['video_id']}</td>";
                                echo "<td>{$row['title']}</td>";
                                echo "<td>{$row['course_id']} " . (isset($row['course_title']) ? "({$row['course_title']})" : "") . "</td>";
                                echo "<td>{$row['teacher_id']}</td>";
                                echo "<td>{$row['created_at']}</td>";
                                echo "<td>";
                                if ($row['teacher_id'] != $current_user_id) {
                                    echo "<a href='?action=fix&video_id={$row['video_id']}' class='btn btn-sm btn-warning'>Assign to Me</a>";
                                } else {
                                    echo "<span class='badge bg-success'>Yours</span>";
                                }
                                echo "</td>";
                                echo "</tr>";
                            }
                        } else {
                            echo "<tr><td colspan='6'>No videos found in database</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header bg-info text-white">
                <h3>Available Courses</h3>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Title</th>
                            <th>Teacher ID</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // Get all courses
                        $result = $conn->query("SELECT * FROM courses ORDER BY course_id");
                        
                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                $teacher_match = ($row['teacher_id'] == $current_user_id) ? 'bg-success text-white' : '';
                                echo "<tr class='$teacher_match'>";
                                echo "<td>{$row['course_id']}</td>";
                                echo "<td>{$row['title']}</td>";
                                echo "<td>{$row['teacher_id']}</td>";
                                echo "</tr>";
                            }
                        } else {
                            echo "<tr><td colspan='3'>No courses found</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="mt-4">
            <a href="videos.php" class="btn btn-primary">Back to Videos</a>
            <a href="upload-video.php" class="btn btn-success">Upload New Video</a>
        </div>
    </div>
</body>
</html>
