<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>🔍 Debugging Withdrawal Page Issues</h2>";

session_start();
echo "<p>✅ Session started</p>";

require_once '../includes/config.php';
echo "<p>✅ Config loaded</p>";

// Check if user is logged in
echo "<p><strong>Session Check:</strong></p>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

if (!isset($_SESSION['user_id'])) {
    echo "<p>❌ No user_id in session - would redirect to login</p>";
    echo "<p><a href='../login.php'>→ Go to Login</a></p>";
    exit();
}

$userId = $_SESSION['user_id'];
echo "<p>✅ User ID: {$userId}</p>";

// Check database connection
if ($conn) {
    echo "<p>✅ Database connected</p>";
} else {
    echo "<p>❌ Database connection failed</p>";
    exit();
}

// Check if payments table exists
echo "<p><strong>Table Check:</strong></p>";
$tables_check = $conn->query("SHOW TABLES LIKE 'payments'");
if ($tables_check && $tables_check->num_rows > 0) {
    echo "<p>✅ payments table exists</p>";
} else {
    echo "<p>⚠️ payments table does NOT exist</p>";
}

$tables_check = $conn->query("SHOW TABLES LIKE 'withdrawal_requests'");
if ($tables_check && $tables_check->num_rows > 0) {
    echo "<p>✅ withdrawal_requests table exists</p>";
} else {
    echo "<p>❌ withdrawal_requests table does NOT exist</p>";
}

// Try the earnings query
echo "<p><strong>Earnings Query Test:</strong></p>";
try {
    $earnings_query = "SELECT SUM(p.amount) as total_earnings 
                      FROM payments p 
                      JOIN courses c ON p.course_id = c.course_id 
                      WHERE c.teacher_id = ? AND p.status = 'completed'";
    $stmt = $conn->prepare($earnings_query);
    if ($stmt) {
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $earnings_result = $stmt->get_result()->fetch_assoc();
        $total_earnings = $earnings_result['total_earnings'] ?: 0;
        echo "<p>✅ Earnings query successful: $" . number_format($total_earnings, 2) . "</p>";
    } else {
        echo "<p>❌ Earnings query prepare failed: " . $conn->error . "</p>";
    }
} catch (Exception $e) {
    echo "<p>❌ Earnings query exception: " . $e->getMessage() . "</p>";
}

// Try the withdrawn amount query
echo "<p><strong>Withdrawn Amount Query Test:</strong></p>";
try {
    $withdrawn_query = "SELECT SUM(amount) as total_withdrawn 
                       FROM withdrawal_requests 
                       WHERE teacher_id = ? AND status IN ('approved', 'completed')";
    $stmt = $conn->prepare($withdrawn_query);
    if ($stmt) {
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $withdrawn_result = $stmt->get_result()->fetch_assoc();
        $total_withdrawn = $withdrawn_result['total_withdrawn'] ?: 0;
        echo "<p>✅ Withdrawn query successful: $" . number_format($total_withdrawn, 2) . "</p>";
    } else {
        echo "<p>❌ Withdrawn query prepare failed: " . $conn->error . "</p>";
    }
} catch (Exception $e) {
    echo "<p>❌ Withdrawn query exception: " . $e->getMessage() . "</p>";
}

// Try the history query
echo "<p><strong>History Query Test:</strong></p>";
try {
    $history_query = "SELECT * FROM withdrawal_requests WHERE teacher_id = ? ORDER BY requested_at DESC";
    $stmt = $conn->prepare($history_query);
    if ($stmt) {
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $withdrawal_history = $stmt->get_result();
        echo "<p>✅ History query successful: " . $withdrawal_history->num_rows . " records found</p>";
    } else {
        echo "<p>❌ History query prepare failed: " . $conn->error . "</p>";
    }
} catch (Exception $e) {
    echo "<p>❌ History query exception: " . $e->getMessage() . "</p>";
}

echo "<h3>🎯 Conclusions:</h3>";
echo "<p>If all queries above are successful, the withdrawal page should work.</p>";
echo "<p><a href='request-withdrawal.php'>→ Try Withdrawal Page Again</a></p>";
echo "<p><a href='dashboard.php'>→ Back to Dashboard</a></p>";
?>
