<?php
// Debug script for videos issue
session_start();

// Include database connection
require_once __DIR__ . '/../includes/db_connection.php';

// Check session
echo "<h2>Debug Information for Videos Page</h2>";
echo "<strong>Session Data:</strong><br>";
echo "User ID: " . ($_SESSION['user_id'] ?? 'Not set') . "<br>";
echo "User Role: " . ($_SESSION['user_role'] ?? 'Not set') . "<br>";
echo "Username: " . ($_SESSION['username'] ?? 'Not set') . "<br><br>";

if (!isset($_SESSION['user_id'])) {
    echo "<span style='color: red;'>❌ No user logged in!</span><br>";
    exit;
}

$userId = $_SESSION['user_id'];
echo "<strong>Current User ID:</strong> $userId<br><br>";

// Check database connection
if (!$conn) {
    echo "<span style='color: red;'>❌ Database connection failed!</span><br>";
    exit;
} else {
    echo "<span style='color: green;'>✅ Database connected successfully</span><br><br>";
}

// Check if videos table exists
$result = $conn->query("SHOW TABLES LIKE 'videos'");
if ($result->num_rows == 0) {
    echo "<span style='color: red;'>❌ Videos table does not exist!</span><br>";
    exit;
} else {
    echo "<span style='color: green;'>✅ Videos table exists</span><br>";
}

// Check videos table structure
echo "<strong>Videos Table Structure:</strong><br>";
$result = $conn->query("DESCRIBE videos");
while ($row = $result->fetch_assoc()) {
    echo "- " . $row['Field'] . " (" . $row['Type'] . ")<br>";
}
echo "<br>";

// Check total videos in database
$result = $conn->query("SELECT COUNT(*) as total FROM videos");
$row = $result->fetch_assoc();
echo "<strong>Total videos in database:</strong> " . $row['total'] . "<br><br>";

// Check videos for current teacher
$stmt = $conn->prepare("SELECT COUNT(*) as count FROM videos WHERE teacher_id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
echo "<strong>Videos for teacher ID $userId:</strong> " . $row['count'] . "<br><br>";

// Check if teacher exists in users table
$stmt = $conn->prepare("SELECT user_id, username, user_role FROM users WHERE user_id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
    echo "<strong>User details:</strong><br>";
    echo "- ID: " . $user['user_id'] . "<br>";
    echo "- Username: " . $user['username'] . "<br>";
    echo "- Role: " . $user['user_role'] . "<br><br>";
} else {
    echo "<span style='color: red;'>❌ User not found in database!</span><br>";
}

// Show actual videos for this teacher
echo "<strong>Actual videos for this teacher:</strong><br>";
$stmt = $conn->prepare("SELECT video_id, title, filename, course_id, created_at FROM videos WHERE teacher_id = ? ORDER BY created_at DESC LIMIT 10");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Video ID</th><th>Title</th><th>Filename</th><th>Course ID</th><th>Created At</th></tr>";
    while ($video = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $video['video_id'] . "</td>";
        echo "<td>" . htmlspecialchars($video['title']) . "</td>";
        echo "<td>" . htmlspecialchars($video['filename']) . "</td>";
        echo "<td>" . $video['course_id'] . "</td>";
        echo "<td>" . $video['created_at'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<span style='color: orange;'>No videos found for this teacher</span><br>";
}

echo "<br><strong>Query used in videos.php:</strong><br>";
$query = "SELECT v.*, c.title as course_title FROM videos v LEFT JOIN courses c ON v.course_id = c.course_id WHERE v.teacher_id = ? ORDER BY v.created_at DESC";
echo "<code>$query</code><br>";

// Test the actual query from videos.php
echo "<br><strong>Testing the actual query:</strong><br>";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
echo "Query returned " . $result->num_rows . " rows<br>";

if ($result->num_rows > 0) {
    echo "<strong>Sample results:</strong><br>";
    $count = 0;
    while ($row = $result->fetch_assoc() && $count < 3) {
        echo "Video: " . htmlspecialchars($row['title']) . " (ID: " . $row['video_id'] . ")<br>";
        $count++;
    }
}
?>
