<?php
require_once '../config/db_connect.php';

echo "<h1>🔧 Direct Thumbnail Fix</h1>";

// Direct SQL updates for each YouTube video
$updates = [
    ['video_id' => 9, 'youtube_id' => 'MyCvTSjkD74', 'title' => 'Bootstrap Framework'],
    ['video_id' => 8, 'youtube_id' => 'MyCvTSjkD74', 'title' => 'Bootstrap Framework'], 
    ['video_id' => 6, 'youtube_id' => '4sosXZ4y-5', 'title' => 'Debug Test Video'],
    ['video_id' => 5, 'youtube_id' => 'test123', 'title' => 'Test Video URL']
];

echo "<h2>📋 Executing Direct Updates</h2>";

foreach ($updates as $update) {
    $video_id = $update['video_id'];
    $youtube_id = $update['youtube_id'];
    $thumbnail_url = "https://img.youtube.com/vi/{$youtube_id}/maxresdefault.jpg";
    
    echo "<div style='padding: 10px; margin: 5px 0; background: #f9f9f9; border-radius: 5px;'>";
    echo "<strong>Updating Video ID {$video_id}:</strong> {$update['title']}<br>";
    echo "<strong>YouTube ID:</strong> {$youtube_id}<br>";
    echo "<strong>Thumbnail URL:</strong> {$thumbnail_url}<br>";
    
    // Execute the update
    $sql = "UPDATE videos SET thumbnail = ? WHERE video_id = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("si", $thumbnail_url, $video_id);
        if ($stmt->execute()) {
            echo "<span style='color: green;'>✅ SUCCESS - Updated successfully!</span><br>";
        } else {
            echo "<span style='color: red;'>❌ ERROR - " . $stmt->error . "</span><br>";
        }
        $stmt->close();
    } else {
        echo "<span style='color: red;'>❌ PREPARE ERROR - " . $conn->error . "</span><br>";
    }
    
    echo "</div>";
}

// Verify the updates
echo "<h2>🔍 Verification</h2>";
$verify_query = "SELECT video_id, title, thumbnail FROM videos WHERE platform = 'youtube' ORDER BY video_id DESC";
$result = $conn->query($verify_query);

if ($result && $result->num_rows > 0) {
    echo "<table border='1' cellpadding='8' style='border-collapse: collapse;'>";
    echo "<tr style='background: #f0f0f0;'><th>Video ID</th><th>Title</th><th>Thumbnail</th><th>Status</th></tr>";
    
    while ($row = $result->fetch_assoc()) {
        $status = $row['thumbnail'] ? 'Has Thumbnail' : 'No Thumbnail';
        $color = $row['thumbnail'] ? 'green' : 'red';
        
        echo "<tr>";
        echo "<td>{$row['video_id']}</td>";
        echo "<td>" . htmlspecialchars($row['title']) . "</td>";
        echo "<td style='font-size: 12px;'>" . ($row['thumbnail'] ?: 'NULL') . "</td>";
        echo "<td style='color: {$color};'>{$status}</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Final status
$count_query = "SELECT COUNT(*) as total_youtube, 
                       SUM(CASE WHEN thumbnail IS NOT NULL AND thumbnail != '' THEN 1 ELSE 0 END) as with_thumbnails
                FROM videos WHERE platform = 'youtube'";
$count_result = $conn->query($count_query);

if ($count_result) {
    $stats = $count_result->fetch_assoc();
    echo "<div style='background: #d4edda; padding: 15px; margin: 20px 0; border-radius: 5px;'>";
    echo "<h3>📊 Final Status:</h3>";
    echo "<ul>";
    echo "<li><strong>Total YouTube videos:</strong> {$stats['total_youtube']}</li>";
    echo "<li><strong>YouTube videos with thumbnails:</strong> {$stats['with_thumbnails']} / {$stats['total_youtube']}</li>";
    
    $percentage = $stats['total_youtube'] > 0 ? round(($stats['with_thumbnails'] / $stats['total_youtube']) * 100, 1) : 0;
    echo "<li><strong>Coverage:</strong> <span style='font-size: 18px; color: " . ($percentage == 100 ? 'green' : 'red') . ";'>{$percentage}%</span></li>";
    echo "</ul>";
    
    if ($percentage == 100) {
        echo "<p style='color: green; font-weight: bold;'>🎉 All YouTube videos now have thumbnails!</p>";
        echo "<p><a href='videos.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>✅ View Videos Page</a></p>";
    }
    echo "</div>";
}

echo "<hr>";
echo "<p><strong>Completed:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
