<?php
/**
 * Finish Content Creation Workflow
 * 
 * Completes the video content creation workflow and cleans up session data.
 */

session_start();
require_once __DIR__ . '/../includes/id_encryption.php';

// Check if workflow session exists
if (!isset($_SESSION['content_workflow'])) {
    $_SESSION['error_message'] = 'No workflow to complete.';
    header('Location: upload-video.php');
    exit();
}

$workflow = $_SESSION['content_workflow'];
$encrypted_video_id = $_GET['video_id'] ?? '';
$video_id = IdEncryption::decrypt($encrypted_video_id);
$skip = isset($_GET['skip']);

// Validate video ID matches workflow
if ($video_id != $workflow['video_id']) {
    $_SESSION['error_message'] = 'Invalid video ID for workflow.';
    header('Location: upload-video.php');
    exit();
}

// Clear workflow from session
unset($_SESSION['content_workflow']);

// Set success message
if ($skip) {
    $_SESSION['success_message'] = 'Video uploaded successfully! You can add content to your video anytime from the video management page.';
} else {
    $completed_count = count($workflow['completed_steps'] ?? []);
    $total_count = count($workflow['content_types']);
    $_SESSION['success_message'] = "Video uploaded successfully! Content creation completed: {$completed_count}/{$total_count} items created.";
}

// Redirect to video list
header('Location: videos.php');
exit();
?>
