<?php
// Script to update the category dropdown in create-course.php to use ID values directly

// Database connection
session_start();
require_once "../config/db_connect.php";

// Get all categories from the database
$categories = [];
$result = $conn->query("SELECT category_id, category_name FROM categories ORDER BY category_name");

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }
}

// Close database connection
$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Fix Category Dropdown</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
        h1, h2 { color: #333; }
        code { background: #f5f5f5; padding: 2px 5px; border-radius: 3px; }
        pre { background: #f5f5f5; padding: 15px; border-radius: 5px; overflow: auto; }
        .step { margin-bottom: 30px; }
        .highlight { background-color: #ffff99; padding: 2px; }
    </style>
</head>
<body>
    <h1>Category Dropdown Fix</h1>
    
    <div class="step">
        <h2>Step 1: Verify Available Categories</h2>
        <p>The following categories were found in your database:</p>
        <ul>
            <?php foreach ($categories as $category): ?>
                <li><strong>ID <?php echo $category['category_id']; ?>:</strong> <?php echo htmlspecialchars($category['category_name']); ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
    
    <div class="step">
        <h2>Step 2: Update Your Category Dropdown</h2>
        <p>Replace your current hardcoded category dropdown in <code>create-course.php</code> with this dynamic version:</p>
        
        <pre>
&lt;div class="mb-4">
    &lt;label for="courseCategory" class="form-label">Category&lt;/label>
    &lt;select class="form-select" id="courseCategory" name="category">
        &lt;option value="">Select a category&lt;/option>
        &lt;?php
        // Fetch categories from database
        $categoriesResult = $conn->query("SELECT category_id, category_name FROM categories ORDER BY category_name");
        if ($categoriesResult && $categoriesResult->num_rows > 0) {
            while ($category = $categoriesResult->fetch_assoc()) {
                echo '&lt;option value="' . $category['category_id'] . '">' . htmlspecialchars($category['category_name']) . '&lt;/option>';
            }
        }
        ?>
    &lt;/select>
    &lt;div class="invalid-feedback">Please select a category&lt;/div>
&lt;/div>
        </pre>
    </div>
    
    <div class="step">
        <h2>Step 3: Update process-create-course.php</h2>
        <p>Update the category handling in <code>process-create-course.php</code> to use the numeric ID directly:</p>
        
        <pre>
// Since the form now sends the category_id directly, we can use it without conversion
if (!empty($data['category']) && is_numeric($data['category'])) {
    $categoryId = (int)$data['category'];
    logDebug("Using direct category_id from form: {$categoryId}");
} else {
    // Default to category ID 1 if no valid ID is provided
    $categoryId = 1; 
    logDebug("No valid category ID provided, using default ID 1");
}
        </pre>
    </div>
    
    <div class="step">
        <h2>Summary of Changes</h2>
        <ol>
            <li>The dropdown will now send category_id values directly instead of category names</li>
            <li>This ensures the foreign key constraint will be satisfied</li>
            <li>The dropdown is populated directly from the database, ensuring all options are valid</li>
            <li>The form field still uses name="category" for backward compatibility</li>
        </ol>
    </div>
</body>
</html>
