<?php
require_once '../config/db_connect.php';

echo "<h1>Thumbnail Fix Utility</h1>";

// Check if thumbnail column exists
$result = $conn->query("SHOW COLUMNS FROM videos LIKE 'thumbnail'");
if ($result->num_rows === 0) {
    // Add thumbnail column if it doesn't exist
    $sql = "ALTER TABLE videos ADD COLUMN thumbnail VARCHAR(255) DEFAULT NULL AFTER duration";
    if ($conn->query($sql)) {
        echo "<p style='color:green'>Added thumbnail column to videos table</p>";
    } else {
        echo "<p style='color:red'>Error adding thumbnail column: " . $conn->error . "</p>";
        exit;
    }
} else {
    echo "<p>Thumbnail column already exists</p>";
}

// Display current thumbnail values
$result = $conn->query("SELECT video_id, title, thumbnail, video_url FROM videos ORDER BY video_id DESC");

echo "<h2>Current Video Data</h2>";
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>ID</th><th>Title</th><th>Thumbnail Path</th><th>Video URL</th><th>Status</th></tr>";

$hasNullThumbnails = false;

if ($result->num_rows > 0) {
    while ($video = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $video['video_id'] . "</td>";
        echo "<td>" . htmlspecialchars($video['title']) . "</td>";
        echo "<td>" . ($video['thumbnail'] ? htmlspecialchars($video['thumbnail']) : "<em style='color:red'>NULL</em>") . "</td>";
        echo "<td>" . htmlspecialchars($video['video_url']) . "</td>";
        
        if (empty($video['thumbnail'])) {
            $hasNullThumbnails = true;
            echo "<td style='color:red'>Missing thumbnail</td>";
        } else {
            // Check if thumbnail file exists
            $thumbnail_path = '../' . $video['thumbnail'];
            if (file_exists($thumbnail_path)) {
                echo "<td style='color:green'>Thumbnail exists</td>";
            } else {
                echo "<td style='color:orange'>Thumbnail file missing</td>";
            }
        }
        
        echo "</tr>";
    }
} else {
    echo "<tr><td colspan='5'>No videos found</td></tr>";
}

echo "</table>";

// Fix option
if ($hasNullThumbnails) {
    echo "<h2>Fix Missing Thumbnails</h2>";
    echo "<p>Click the button below to regenerate thumbnail paths for videos missing thumbnails:</p>";
    
    if (isset($_POST['fix_thumbnails'])) {
        // Update videos with missing thumbnails to use the video thumbnail
        $stmt = $conn->prepare("UPDATE videos SET thumbnail = CONCAT('uploads/thumbnails/', SUBSTRING_INDEX(video_url, '/', -1)) WHERE thumbnail IS NULL OR thumbnail = ''");
        if ($stmt->execute()) {
            echo "<p style='color:green'>Successfully updated " . $stmt->affected_rows . " videos with default thumbnails.</p>";
            echo "<p><a href='fix_thumbnails.php'>Refresh to verify</a></p>";
        } else {
            echo "<p style='color:red'>Error updating thumbnails: " . $stmt->error . "</p>";
        }
        $stmt->close();
    } else {
        echo "<form method='post'>";
        echo "<input type='submit' name='fix_thumbnails' value='Fix Missing Thumbnails'>";
        echo "</form>";
    }
}

// Testing the thumbnail image display
echo "<h2>Thumbnail Display Test</h2>";
$testResult = $conn->query("SELECT video_id, title, thumbnail FROM videos WHERE thumbnail IS NOT NULL LIMIT 1");
if ($testResult && $testResult->num_rows > 0) {
    $testVideo = $testResult->fetch_assoc();
    
    echo "<h3>Testing thumbnail for video: " . htmlspecialchars($testVideo['title']) . "</h3>";
    echo "<p>Raw thumbnail path: " . $testVideo['thumbnail'] . "</p>";
    
    // Test multiple path formats
    $paths = [
        "Standard path" => "../" . $testVideo['thumbnail'],
        "Direct path" => $testVideo['thumbnail'],
        "Path with ../uploads/" => "../uploads/thumbnails/" . basename($testVideo['thumbnail']),
        "Path with just file name" => "../uploads/thumbnails/" . basename($testVideo['thumbnail'])
    ];
    
    echo "<div style='display: flex; flex-wrap: wrap;'>";
    foreach ($paths as $label => $path) {
        echo "<div style='margin: 10px; text-align: center;'>";
        echo "<p><strong>" . $label . "</strong><br>" . $path . "</p>";
        echo "<img src=\"" . htmlspecialchars($path) . "\" alt=\"Thumbnail test\" style=\"max-width: 200px; border: 1px solid #ccc;\"><br>";
        echo "File " . (file_exists($path) ? "<span style='color:green'>exists</span>" : "<span style='color:red'>does not exist</span>");
        echo "</div>";
    }
    echo "</div>";
}
?>
