<?php
// Include the centralized teacher layout
require_once __DIR__ . '/components/teacher_layout.php';

// Include ID encryption utility
require_once "../includes/id_encryption.php";

include_once "../includes/functions.php";
require_once "../auth/functions.php";

// Error handling and reporting during development
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Get course ID from URL - handle both encrypted and legacy IDs
$course_id = 0;
if (isset($_GET['id'])) {
    if (is_numeric($_GET['id'])) {
        // Legacy integer ID (for backward compatibility)
        $course_id = (int)$_GET['id'];
    } else {
        // Try to decrypt encrypted ID
        $course_id = IdEncryption::decrypt($_GET['id']);
        if ($course_id === false) {
            header("Location: courses.php?error=Invalid course ID");
            exit();
        }
    }
}

$teacher_id = $_SESSION['user_id'];

if ($course_id === 0) {
    header("Location: courses.php");
    exit();
}

try {
    // Check database connection first
    if (!$conn) {
        die("Database connection failed");
    }
    
    // Fetch course details
    $course_query = "SELECT * FROM courses WHERE course_id = $course_id AND teacher_id = $teacher_id";
    $course_result = $conn->query($course_query);
    
    if (!$course_result || $course_result->num_rows === 0) {
        header("Location: courses.php?error=Course not found or access denied");
        exit();
    }
    
    $course = $course_result->fetch_assoc();
    
    // Get category name
    $course['category_name'] = 'Uncategorized';
    if (isset($course['category_id']) && $course['category_id']) {
        $cat_query = "SELECT name FROM categories WHERE category_id = " . (int)$course['category_id'];
        $cat_result = $conn->query($cat_query);
        if ($cat_result && $cat_result->num_rows > 0) {
            $cat_data = $cat_result->fetch_assoc();
            $course['category_name'] = $cat_data['name'];
        }
    }
    
    // Initialize stats
    $stats = [
        'total_videos' => 0,
        'total_quizzes' => 0,
        'total_materials' => 0,
        'enrolled_students' => 0
    ];
    
    // Count videos
    $video_result = $conn->query("SELECT COUNT(*) as count FROM videos WHERE course_id = $course_id");
    if ($video_result) {
        $stats['total_videos'] = $video_result->fetch_assoc()['count'];
    }
    
    // Count quizzes
    $quiz_result = $conn->query("SELECT COUNT(*) as count FROM quizzes WHERE course_id = $course_id");
    if ($quiz_result) {
        $stats['total_quizzes'] = $quiz_result->fetch_assoc()['count'];
    }
    
    // Count materials
    $material_tables = ['course_materials', 'materials', 'course_files'];
    foreach ($material_tables as $table) {
        $material_result = $conn->query("SELECT COUNT(*) as count FROM {$table} WHERE course_id = $course_id");
        if ($material_result) {
            $stats['total_materials'] = $material_result->fetch_assoc()['count'];
            break;
        }
    }
    
    // Count students
    $enrollment_tables = ['enrollments', 'course_enrollments', 'student_enrollments'];
    foreach ($enrollment_tables as $table) {
        $enrollment_result = $conn->query("SELECT COUNT(*) as count FROM {$table} WHERE course_id = $course_id");
        if ($enrollment_result) {
            $stats['enrolled_students'] = $enrollment_result->fetch_assoc()['count'];
            break;
        }
    }
    
} catch(Exception $e) {
    error_log("Error fetching course data: " . $e->getMessage());
    header("Location: courses.php?error=Database error");
    exit();
}

// Set current page for sidebar
$current_page = 'manage-content.php';
?>

<style>
    /* Modern Panadite Design - Manage Content */
    * {
        font-family: 'Inter', 'Poppins', sans-serif !important;
    }

    :root {
        --primary-color: #4361ee;
        --secondary-color: #3f37c9;
        --success-color: #22c55e;
        --info-color: #06b6d4;
        --warning-color: #f59e0b;
        --danger-color: #ef4444;
        --light-color: #f8fafc;
        --dark-color: #1f2937;
    }

    body {
        background-color: var(--light-color) !important;
    }

    .manage-container {
        padding: 0 30px !important;
    }
    
    /* Clean Course Header */
    .course-header {
        background: #ffffff !important;
        border: 1px solid #f1f5f9 !important;
        border-radius: 12px !important;
        padding: 24px !important;
        margin-bottom: 32px !important;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08) !important;
        position: relative !important;
    }
    
    .course-title {
        font-size: 24px !important;
        font-weight: 700 !important;
        color: #1f2937 !important;
        margin-bottom: 8px !important;
        line-height: 1.3 !important;
        display: flex !important;
        align-items: center !important;
    }

    .course-title i {
        color: var(--primary-color) !important;
        font-size: 28px !important;
        margin-right: 12px !important;
    }
    
    .course-description {
        font-size: 14px !important;
        color: #6b7280 !important;
        line-height: 1.6 !important;
        margin-bottom: 16px !important;
    }
    
    .course-meta {
        display: flex !important;
        gap: 16px !important;
        flex-wrap: wrap !important;
        margin-top: 0 !important;
    }
    
    .meta-badge {
        background: #f8fafc !important;
        color: #6b7280 !important;
        padding: 6px 12px !important;
        border-radius: 20px !important;
        font-size: 12px !important;
        font-weight: 500 !important;
        display: flex;
        align-items: center;
        gap: 6px !important;
        border: 1px solid #e5e7eb !important;
    }

    .meta-badge i {
        color: var(--primary-color) !important;
    }
    
    /* Modern Stats Cards Container */
    .stats-container {
        background: white !important;
        border-radius: 12px !important;
        padding: 24px !important;
        margin-bottom: 32px !important;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08) !important;
        border: 1px solid #f1f5f9 !important;
    }
    
    .stats-title {
        font-size: 18px !important;
        font-weight: 600 !important;
        color: #1f2937 !important;
        margin-bottom: 20px !important;
        display: flex !important;
        align-items: center !important;
    }
    
    .stats-title i {
        color: var(--primary-color) !important;
        margin-right: 8px !important;
    }
    
    .stats-grid {
        display: grid !important;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)) !important;
        gap: 16px !important;
    }
    
    .stat-card {
        background: white !important;
        border: 1px solid #f1f5f9 !important;
        border-radius: 8px !important;
        padding: 20px !important;
        text-align: center !important;
        transition: all 0.3s ease !important;
        position: relative !important;
    }
    
    .stat-card:hover {
        transform: translateY(-2px) !important;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15) !important;
    }
    
    .stat-icon {
        width: 48px !important;
        height: 48px !important;
        border-radius: 50% !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        margin: 0 auto 12px !important;
        font-size: 20px !important;
        color: white !important;
    }
    
    .stat-icon.videos { background: var(--info-color) !important; }
    .stat-icon.quizzes { background: var(--warning-color) !important; }
    .stat-icon.materials { background: var(--success-color) !important; }
    .stat-icon.students { background: var(--primary-color) !important; }
    
    .stat-number {
        font-size: 28px !important;
        font-weight: 700 !important;
        color: #1f2937 !important;
        margin-bottom: 4px !important;
        line-height: 1 !important;
    }
    
    .stat-label {
        font-size: 13px !important;
        color: #6b7280 !important;
        font-weight: 500 !important;
        text-transform: uppercase !important;
        letter-spacing: 0.5px !important;
    }
    
    /* Section Titles */
    .section-title {
        font-size: 20px !important;
        font-weight: 600 !important;
        color: #1f2937 !important;
        margin-bottom: 16px !important;
        display: flex !important;
        align-items: center !important;
    }
    
    .section-title i {
        color: var(--primary-color) !important;
        margin-right: 8px !important;
    }

    /* Modern Action Cards */
    .actions-section {
        margin-bottom: 32px !important;
    }
    
    .actions-grid {
        display: grid !important;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)) !important;
        gap: 20px !important;
        margin-bottom: 24px !important;
    }
    
    .action-card {
        background: white !important;
        border: 1px solid #f1f5f9 !important;
        border-radius: 12px !important;
        padding: 24px !important;
        text-align: center !important;
        text-decoration: none !important;
        color: inherit !important;
        display: block !important;
        transition: all 0.3s ease !important;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08) !important;
    }
    
    .action-card:hover {
        transform: translateY(-4px) !important;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15) !important;
        color: inherit !important;
        text-decoration: none !important;
        border-color: var(--primary-color) !important;
    }
    
    .action-card.videos .action-icon { background: var(--info-color) !important; }
    .action-card.quizzes .action-icon { background: var(--warning-color) !important; }
    .action-card.materials .action-icon { background: var(--success-color) !important; }
    .action-card.settings .action-icon { background: #6b7280 !important; }
    
    .action-icon {
        width: 64px !important;
        height: 64px !important;
        border-radius: 50% !important;
        color: white !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        margin: 0 auto 16px !important;
        font-size: 24px !important;
    }

    .action-title {
        font-size: 18px !important;
        font-weight: 600 !important;
        color: #1f2937 !important;
        margin-bottom: 8px !important;
    }
    
    .action-description {
        color: #6b7280 !important;
        font-size: 14px !important;
        margin-bottom: 16px !important;
        line-height: 1.5 !important;
    }
    
    .action-count {
        color: var(--primary-color) !important;
        font-weight: 600 !important;
        font-size: 14px !important;
        background: #eff6ff !important;
        padding: 4px 12px !important;
        border-radius: 12px !important;
        display: inline-block !important;
    }
    
    /* Modern Quick Actions */
    .quick-actions {
        background: white !important;
        border: 1px solid #f1f5f9 !important;
        border-radius: 12px !important;
        padding: 24px !important;
        margin-bottom: 32px !important;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08) !important;
    }
    
    .quick-actions-grid {
        display: grid !important;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)) !important;
        gap: 20px !important;
    }
    
    .quick-action-item {
        display: flex !important;
        align-items: flex-start !important;
        padding: 20px !important;
        background: #f8fafc !important;
        border-radius: 8px !important;
        border: 1px solid #f1f5f9 !important;
        transition: all 0.3s ease !important;
    }
    
    .quick-action-item:hover {
        background: white !important;
        border-color: var(--primary-color) !important;
        transform: translateY(-2px) !important;
    }
    
    .quick-action-icon {
        width: 48px !important;
        height: 48px !important;
        border-radius: 50% !important;
        background: var(--primary-color) !important;
        color: white !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        margin-right: 16px !important;
        font-size: 18px !important;
        flex-shrink: 0 !important;
    }

    .quick-action-content h5 {
        margin-bottom: 6px !important;
        color: #1f2937 !important;
        font-weight: 600 !important;
        font-size: 16px !important;
    }
    
    .quick-action-content p {
        margin-bottom: 12px !important;
        color: #6b7280 !important;
        font-size: 14px !important;
        line-height: 1.5 !important;
    }
    
    /* Modern Button Styles */
    .btn-primary-custom {
        background: var(--primary-color) !important;
        border: none !important;
        color: white !important;
        padding: 10px 16px !important;
        border-radius: 6px !important;
        font-weight: 500 !important;
        font-size: 14px !important;
        text-decoration: none !important;
        display: inline-flex !important;
        align-items: center !important;
        gap: 6px !important;
        transition: all 0.3s ease !important;
    }
    
    .btn-primary-custom:hover {
        background: var(--secondary-color) !important;
        transform: translateY(-1px) !important;
        color: white !important;
        text-decoration: none !important;
        box-shadow: 0 4px 12px rgba(67, 97, 238, 0.3) !important;
    }
    
    .btn-orange-custom {
        background: var(--warning-color) !important;
        border: none !important;
        color: white !important;
        padding: 10px 16px !important;
        border-radius: 6px !important;
        font-weight: 500 !important;
        font-size: 14px !important;
        text-decoration: none !important;
        display: inline-flex !important;
        align-items: center !important;
        gap: 6px !important;
        transition: all 0.3s ease !important;
    }

    .btn-orange-custom:hover {
        background: #ea580c !important;
        transform: translateY(-1px) !important;
        color: white !important;
        text-decoration: none !important;
        box-shadow: 0 4px 12px rgba(245, 158, 11, 0.3) !important;
    }
    
    .btn-back {
        background: #6b7280 !important;
        color: white !important;
        padding: 12px 20px !important;
        border-radius: 6px !important;
        font-weight: 500 !important;
        font-size: 14px !important;
        text-decoration: none !important;
        display: inline-flex !important;
        align-items: center !important;
        gap: 8px !important;
        transition: all 0.3s ease !important;
        border: none !important;
    }
    
    .btn-back:hover {
        background: #4b5563 !important;
        transform: translateY(-1px) !important;
        color: white !important;
        text-decoration: none !important;
        box-shadow: 0 4px 12px rgba(107, 114, 128, 0.3) !important;
    }
    
    .text-muted {
        color: #6b7280 !important;
        font-size: 14px !important;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .manage-container {
            padding: 0 20px !important;
        }
        
        .course-header {
            padding: 20px;
            text-align: center;
        }
        
        .course-title {
            font-size: 1.5rem;
        }
        
        .course-meta {
            justify-content: center;
        }
        
        .stats-grid {
            grid-template-columns: repeat(2, 1fr);
        }
        
        .actions-grid {
            grid-template-columns: 1fr;
        }
        
        .quick-actions-grid {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 480px) {
        .manage-container {
            padding: 15px;
        }
        
        .stats-grid {
            grid-template-columns: 1fr;
        }
        
        .course-meta {
            flex-direction: column;
            gap: 10px;
        }
    }
</style>

<div class="manage-container">
    <!-- Clean Course Header -->
    <div class="course-header">
        <div class="d-flex justify-content-between align-items-start">
            <div>
                <h1 class="course-title">
                    <i class='bx bx-cog'></i>
                    Manage: <?= htmlspecialchars($course['title']) ?>
                </h1>
                <p class="course-description">Content management for your course</p>
                <div class="course-meta">
                    <div class="meta-badge">
                        <i class='bx bx-tag'></i>
                        <?= htmlspecialchars($course['category_name']) ?>
                    </div>
                    <div class="meta-badge">
                        <i class='bx bx-calendar'></i>
                        Created <?= date('M j, Y', strtotime($course['created_at'])) ?>
                    </div>
                    <div class="meta-badge">
                        <i class='bx <?= $course['is_published'] ? 'bx-check-circle' : 'bx-x-circle' ?>'></i>
                        <?= $course['is_published'] ? 'Published' : 'Draft' ?>
                    </div>
                </div>
            </div>
            <div>
                <a href="view-course.php?id=<?= $course_id ?>" class="btn-primary-custom">
                    <i class='bx bx-show'></i> View Course
                </a>
            </div>
        </div>
    </div>

    <!-- Modern Statistics Container -->
    <div class="stats-container">
        <h2 class="stats-title">
            <i class='bx bx-bar-chart-alt-2'></i>
            Course Overview
        </h2>
        <p class="text-muted mb-3">Quick statistics about your course content</p>
        
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon videos">
                    <i class='bx bx-video'></i>
                </div>
                <div class="stat-number"><?= $stats['total_videos'] ?></div>
                <div class="stat-label">Videos</div>
            </div>
            <div class="stat-card">
                <div class="stat-icon quizzes">
                    <i class='bx bx-list-check'></i>
                </div>
                <div class="stat-number"><?= $stats['total_quizzes'] ?></div>
                <div class="stat-label">Quizzes</div>
            </div>
            <div class="stat-card">
                <div class="stat-icon materials">
                    <i class='bx bx-file'></i>
                </div>
                <div class="stat-number"><?= $stats['total_materials'] ?></div>
                <div class="stat-label">Materials</div>
            </div>
            <div class="stat-card">
                <div class="stat-icon students">
                    <i class='bx bx-group'></i>
                </div>
                <div class="stat-number"><?= $stats['enrolled_students'] ?></div>
                <div class="stat-label">Students</div>
            </div>
        </div>
    </div>

    <!-- Modern Action Cards -->
    <div class="actions-section">
        <h2 class="section-title">
            <i class='bx bx-grid-alt'></i>
            Content Management
        </h2>
        
        <div class="actions-grid">
            <a href="<?php echo IdEncryption::generateUrl('videos.php', $course_id, 'course_id'); ?>" class="action-card videos">
                <div class="action-icon">
                    <i class='bx bx-video'></i>
                </div>
                <div class="action-title">Manage Videos</div>
                <div class="action-description">Upload, edit, and organize your video lessons</div>
                <div class="action-count"><?= $stats['total_videos'] ?> Videos</div>
            </a>
            
            <a href="<?php echo IdEncryption::generateUrl('quizzes.php', $course_id, 'course_id'); ?>" class="action-card quizzes">
                <div class="action-icon">
                    <i class='bx bx-list-check'></i>
                </div>
                <div class="action-title">Manage Quizzes</div>
                <div class="action-description">Create and edit quizzes to test student knowledge</div>
                <div class="action-count"><?= $stats['total_quizzes'] ?> Quizzes</div>
            </a>
            
            <a href="<?php echo IdEncryption::generateUrl('course-materials.php', $course_id, 'course_id'); ?>" class="action-card materials">
                <div class="action-icon">
                    <i class='bx bx-file'></i>
                </div>
                <div class="action-title">Course Materials</div>
                <div class="action-description">Upload PDFs, documents, and resources</div>
                <div class="action-count"><?= $stats['total_materials'] ?> Files</div>
            </a>
            
            <a href="<?php echo IdEncryption::generateUrl('settings.php', $course_id, 'id'); ?>" class="action-card settings">
                <div class="action-icon">
                    <i class='bx bx-cog'></i>
                </div>
                <div class="action-title">Course Settings</div>
                <div class="action-description">Edit course details, pricing, and visibility</div>
                <div class="action-count">Settings</div>
            </a>
        </div>
    </div>

    <!-- Modern Quick Actions -->
    <div class="quick-actions">
        <h2 class="section-title">
            <i class='bx bx-zap'></i>
            Quick Actions
        </h2>
        <p class="text-muted mb-3">Common tasks to manage your course content</p>
        
        <div class="quick-actions-grid">
            <div class="quick-action-item">
                <div class="quick-action-icon">
                    <i class='bx bx-plus'></i>
                </div>
                <div class="quick-action-content">
                    <h5>Add New Video</h5>
                    <p>Upload a new video lesson to your course</p>
                    <a href="upload-video.php?course_id=<?= $course_id ?>" class="btn-primary-custom">
                        <i class='bx bx-plus'></i> Add Video
                    </a>
                </div>
            </div>
            
            <div class="quick-action-item">
                <div class="quick-action-icon">
                    <i class='bx bx-question-mark'></i>
                </div>
                <div class="quick-action-content">
                    <h5>Create New Quiz</h5>
                    <p>Design a quiz to test your students</p>
                    <a href="create_quiz.php?course_id=<?= $course_id ?>" class="btn-orange-custom">
                        <i class='bx bx-plus'></i> Create Quiz
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Navigation Back -->
    <div class="text-center">
        <a href="courses.php" class="btn-back">
            <i class='bx bx-arrow-back'></i> Back to My Courses
        </a>
    </div>
</div>

<?php
// Include any additional scripts or footer content if needed
?>
