<?php
// Get current user information
$user_name = isset($_SESSION['first_name']) ? $_SESSION['first_name'] . ' ' . $_SESSION['last_name'] : 'Teacher';
$user_initials = isset($_SESSION['first_name']) ? substr($_SESSION['first_name'], 0, 1) . substr($_SESSION['last_name'], 0, 1) : 'T';
?>
<nav class="airbnb-style-navbar">
    <!-- Left Section - Logo -->
    <div class="airbnb-nav-left">
        <div class="panadite-logo">
            <i class='bx bx-book-bookmark panadite-logo-icon'></i>
            <span class="panadite-logo-text">Panadite Academy</span>
        </div>
    </div>
    
    <!-- Center Section - Multi-part Search (Airbnb Style) -->
    <div class="airbnb-search-container">
        <div class="airbnb-search-bar">
            <div class="search-section">
                <div class="search-label">Search</div>
                <input type="text" placeholder="Courses, students..." class="search-input">
            </div>
            <div class="search-divider"></div>
            <div class="search-section">
                <div class="search-label">Category</div>
                <input type="text" placeholder="All categories" class="search-input">
            </div>
            <div class="search-divider"></div>
            <div class="search-section">
                <div class="search-label">Filter</div>
                <input type="text" placeholder="Add filters" class="search-input">
            </div>
            <button class="airbnb-search-btn">
                <i class='bx bx-search'></i>
            </button>
        </div>
    </div>
    
    <!-- Right Section - Menu -->
    <div class="airbnb-nav-right">
        <!-- Create Course Link -->
        <a href="create-course.php" class="create-course-link">Create Course</a>
        
        <!-- Notifications -->
        <button class="airbnb-icon-btn" onclick="toggleNotifications()">
            <i class='bx bx-bell'></i>
            <span class="notification-dot">3</span>
        </button>
        
        <!-- User Menu -->
        <div class="dropdown">
            <div class="airbnb-user-menu dropdown-toggle" data-bs-toggle="dropdown">
                <i class='bx bx-menu'></i>
                <div class="user-avatar">
                    <?= $user_initials ?>
                </div>
            </div>
            <ul class="dropdown-menu dropdown-menu-end airbnb-dropdown">
                <li class="dropdown-header">
                    <div class="user-info">
                        <strong><?= $user_name ?></strong>
                        <span>Teacher Account</span>
                    </div>
                </li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="dashboard.php">Dashboard</a></li>
                <li><a class="dropdown-item" href="profile.php">Account</a></li>
                <li><a class="dropdown-item" href="analytics.php">Analytics</a></li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="/auth/logout.php">Log out</a></li>
            </ul>
        </div>
    </div>
</nav>

<script>
function toggleNotifications() {
    // Simple notification toggle functionality
    console.log('Notifications clicked');
    // You can add more notification functionality here
}
</script>
