<?php
// Debug script to check session and authentication
// Include basic session start
include_once "../includes/session_start.php";

// Output headers for better readability
header("Content-Type: text/plain");

// Display current session information
echo "=== SESSION INFORMATION ===\n";
echo "Session ID: " . session_id() . "\n";
echo "Session Status: " . (session_status() == PHP_SESSION_ACTIVE ? "ACTIVE" : "NOT ACTIVE") . "\n\n";

echo "=== SESSION VARIABLES ===\n";
if (!empty($_SESSION)) {
    foreach ($_SESSION as $key => $value) {
        if (is_array($value)) {
            echo "$key: " . json_encode($value) . "\n";
        } else {
            echo "$key: $value\n";
        }
    }
} else {
    echo "No session variables set\n";
}

echo "\n=== REQUEST INFORMATION ===\n";
echo "Current Script: " . $_SERVER['SCRIPT_NAME'] . "\n";
echo "Current URI: " . $_SERVER['REQUEST_URI'] . "\n";
echo "Current Directory: " . dirname($_SERVER['SCRIPT_NAME']) . "\n";

echo "\n=== AUTHENTICATION STATUS ===\n";
if (isset($_SESSION['user_id']) && isset($_SESSION['user_role'])) {
    echo "User ID: " . $_SESSION['user_id'] . "\n";
    echo "User Role: " . $_SESSION['user_role'] . "\n";
    echo "Authenticated as teacher: " . ($_SESSION['user_role'] === 'teacher' ? "YES" : "NO") . "\n";
} else {
    echo "Not authenticated\n";
}

echo "\n=== SESSION PATH INFORMATION ===\n";
echo "Session save path: " . session_save_path() . "\n";
echo "Session name: " . session_name() . "\n";
echo "Session cookie parameters: " . json_encode(session_get_cookie_params()) . "\n";
?>
