<?php
require_once '../config/db_connect.php';

echo "<h2>🔧 Profile Picture Upload Debug Test</h2>";

$user_id = 28;

echo "<div style='padding: 15px; background: #e3f2fd; border: 1px solid #2196f3; margin: 10px 0;'>";
echo "<h3>📋 Current Status Check:</h3>";

// Check current profile picture value
$query = "SELECT profile_picture, first_name, last_name FROM users WHERE user_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

echo "<strong>Current profile_picture value:</strong> " . ($user['profile_picture'] ? $user['profile_picture'] : 'NULL') . "<br>";
echo "<strong>User name:</strong> " . $user['first_name'] . " " . $user['last_name'] . "<br>";

// Check uploads directory
$upload_dir = "../uploads/profile_pictures/";
echo "<strong>Upload directory exists:</strong> " . (is_dir($upload_dir) ? 'YES' : 'NO') . "<br>";
echo "<strong>Upload directory writable:</strong> " . (is_writable($upload_dir) ? 'YES' : 'NO') . "<br>";

// List existing files in upload directory
if (is_dir($upload_dir)) {
    $files = scandir($upload_dir);
    $files = array_filter($files, function($file) { return !in_array($file, ['.', '..', '.gitkeep']); });
    echo "<strong>Files in upload directory:</strong> " . (count($files) > 0 ? implode(', ', $files) : 'None') . "<br>";
}

echo "</div>";

// Check PHP upload settings
echo "<div style='padding: 15px; background: #f3e5f5; border: 1px solid #9c27b0; margin: 10px 0;'>";
echo "<h3>⚙️ PHP Upload Configuration:</h3>";
echo "<strong>file_uploads:</strong> " . (ini_get('file_uploads') ? 'ON' : 'OFF') . "<br>";
echo "<strong>upload_max_filesize:</strong> " . ini_get('upload_max_filesize') . "<br>";
echo "<strong>post_max_size:</strong> " . ini_get('post_max_size') . "<br>";
echo "<strong>max_execution_time:</strong> " . ini_get('max_execution_time') . "s<br>";
echo "</div>";

// Simple upload form for testing
echo "<div style='padding: 15px; background: #e8f5e9; border: 1px solid #4caf50; margin: 10px 0;'>";
echo "<h3>🧪 Test Upload Form:</h3>";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['test_upload'])) {
    echo "<h4>📤 Upload Attempt Results:</h4>";
    
    echo "<strong>POST data received:</strong> YES<br>";
    echo "<strong>FILES array exists:</strong> " . (isset($_FILES['test_upload']) ? 'YES' : 'NO') . "<br>";
    
    if (isset($_FILES['test_upload'])) {
        echo "<strong>File name:</strong> " . $_FILES['test_upload']['name'] . "<br>";
        echo "<strong>File type:</strong> " . $_FILES['test_upload']['type'] . "<br>";
        echo "<strong>File size:</strong> " . $_FILES['test_upload']['size'] . " bytes<br>";
        echo "<strong>Upload error code:</strong> " . $_FILES['test_upload']['error'] . "<br>";
        echo "<strong>Temp file location:</strong> " . $_FILES['test_upload']['tmp_name'] . "<br>";
        
        if ($_FILES['test_upload']['error'] === 0) {
            $test_filename = $user_id . '_test_' . time() . '_' . basename($_FILES['test_upload']['name']);
            $test_target = $upload_dir . $test_filename;
            
            echo "<strong>Target path:</strong> " . $test_target . "<br>";
            
            if (move_uploaded_file($_FILES['test_upload']['tmp_name'], $test_target)) {
                echo "<div style='color: green; font-weight: bold; margin: 10px 0;'>✅ FILE UPLOAD SUCCESSFUL!</div>";
                
                // Try database update
                $test_path = "uploads/profile_pictures/" . $test_filename;
                $update_query = "UPDATE users SET profile_picture = ? WHERE user_id = ?";
                $update_stmt = $conn->prepare($update_query);
                $update_stmt->bind_param("si", $test_path, $user_id);
                
                if ($update_stmt->execute()) {
                    echo "<div style='color: green; font-weight: bold; margin: 10px 0;'>✅ DATABASE UPDATE SUCCESSFUL!</div>";
                    echo "<strong>New profile_picture value:</strong> " . $test_path . "<br>";
                } else {
                    echo "<div style='color: red; font-weight: bold; margin: 10px 0;'>❌ DATABASE UPDATE FAILED: " . $update_stmt->error . "</div>";
                }
            } else {
                echo "<div style='color: red; font-weight: bold; margin: 10px 0;'>❌ FILE MOVE FAILED!</div>";
                echo "<strong>Possible reasons:</strong><br>";
                echo "- Directory permissions<br>";
                echo "- Disk space<br>";
                echo "- Invalid file path<br>";
            }
        } else {
            echo "<div style='color: red; font-weight: bold; margin: 10px 0;'>❌ UPLOAD ERROR CODE: " . $_FILES['test_upload']['error'] . "</div>";
            $upload_errors = [
                1 => 'File exceeds upload_max_filesize',
                2 => 'File exceeds MAX_FILE_SIZE',
                3 => 'File was only partially uploaded',
                4 => 'No file was uploaded',
                6 => 'Missing temporary folder',
                7 => 'Failed to write file to disk',
                8 => 'PHP extension stopped upload'
            ];
            echo "<strong>Error meaning:</strong> " . ($upload_errors[$_FILES['test_upload']['error']] ?? 'Unknown error') . "<br>";
        }
    }
} else {
    echo "<form method='post' enctype='multipart/form-data'>";
    echo "<p>Select a small test image to upload:</p>";
    echo "<input type='file' name='test_upload' accept='image/*' required>";
    echo "<br><br>";
    echo "<button type='submit' style='background: #4caf50; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer;'>Test Upload</button>";
    echo "</form>";
}

echo "</div>";

echo "<div style='padding: 15px; background: #fff3e0; border: 1px solid #ff9800; margin: 10px 0;'>";
echo "<h3>🎯 Next Steps:</h3>";
echo "<ol>";
echo "<li><strong>Test upload using this form</strong> - This will show exact error details</li>";
echo "<li><strong>Check browser console</strong> on profile page when uploading</li>";
echo "<li><strong>Try uploading from profile page</strong> and check success messages</li>";
echo "<li><strong>Delete this file after testing</strong> (contains debug info)</li>";
echo "</ol>";
echo "</div>";
?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
h2 { color: #333; }
h3 { color: #555; margin: 0 0 10px 0; }
</style>
