<?php
session_start();
require_once '../includes/config.php';

// Check if user is logged in and is a teacher
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'teacher') {
    header('Location: ../login.php');
    exit();
}

$teacher_id = $_SESSION['user_id'];

// Get teacher's courses
$courses_query = "SELECT course_id, title FROM courses WHERE teacher_id = ? ORDER BY title";
$stmt = $conn->prepare($courses_query);
$stmt->bind_param("i", $teacher_id);
$stmt->execute();
$courses_result = $stmt->get_result();
$courses = $courses_result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload Video - Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
    <style>
        .upload-area {
            border: 2px dashed #007bff;
            border-radius: 10px;
            padding: 40px;
            text-align: center;
            background: #f8f9fa;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .upload-area:hover {
            border-color: #0056b3;
            background: #e9ecef;
        }
        .upload-area.dragover {
            border-color: #28a745;
            background: #d4edda;
        }
        .upload-icon {
            font-size: 48px;
            color: #007bff;
            margin-bottom: 20px;
        }
        .progress-container {
            display: none;
            margin-top: 20px;
        }
        .preview-container {
            display: none;
            margin-top: 20px;
        }
        .thumbnail-preview {
            max-width: 200px;
            max-height: 150px;
            border-radius: 8px;
        }
        .video-preview {
            max-width: 100%;
            max-height: 300px;
            border-radius: 8px;
        }
        .file-info {
            background: #e9ecef;
            padding: 15px;
            border-radius: 8px;
            margin-top: 15px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 d-md-block bg-light sidebar">
                <div class="sidebar-sticky pt-3">
                    <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
                        <span>Navigation</span>
                    </h6>
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="dashboard.php">
                                <i class="fas fa-tachometer-alt"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="courses.php">
                                <i class="fas fa-book"></i> Courses
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="videos.php">
                                <i class="fas fa-video"></i> Videos
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="upload-video-new.php">
                                <i class="fas fa-cloud-upload-alt"></i> Upload Video
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Upload New Video</h1>
                </div>

                <div class="row">
                    <div class="col-lg-8">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Video Upload</h5>
                            </div>
                            <div class="card-body">
                                <form id="videoUploadForm">
                                    <!-- Video File Upload -->
                                    <div class="mb-4">
                                        <label class="form-label">Video File</label>
                                        <div class="upload-area" id="uploadArea">
                                            <i class="fas fa-cloud-upload-alt upload-icon"></i>
                                            <h5>Drag & Drop your video here</h5>
                                            <p class="text-muted mb-3">or click to browse</p>
                                            <button type="button" class="btn btn-primary" id="browseBtn">
                                                <i class="fas fa-folder-open"></i> Browse Files
                                            </button>
                                            <input type="file" id="videoFile" name="video" accept="video/*" style="display: none;">
                                        </div>
                                        
                                        <!-- Progress Bar -->
                                        <div class="progress-container" id="progressContainer">
                                            <div class="progress mb-3">
                                                <div class="progress-bar progress-bar-striped progress-bar-animated" 
                                                     id="uploadProgress" role="progressbar" style="width: 0%">
                                                    0%
                                                </div>
                                            </div>
                                            <div class="file-info" id="fileInfo">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <strong>File:</strong> <span id="fileName"></span>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <strong>Size:</strong> <span id="fileSize"></span>
                                                    </div>
                                                </div>
                                                <div class="row mt-2">
                                                    <div class="col-md-6">
                                                        <strong>Duration:</strong> <span id="videoDuration">Detecting...</span>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <strong>Status:</strong> <span id="uploadStatus">Ready</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Video Preview -->
                                        <div class="preview-container" id="previewContainer">
                                            <video id="videoPreview" class="video-preview" controls></video>
                                        </div>
                                    </div>

                                    <!-- Video Details -->
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="videoTitle" class="form-label">Video Title *</label>
                                                <input type="text" class="form-control" id="videoTitle" name="title" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="courseSelect" class="form-label">Course *</label>
                                                <select class="form-select" id="courseSelect" name="course_id" required>
                                                    <option value="">Select a course</option>
                                                    <?php foreach ($courses as $course): ?>
                                                        <option value="<?php echo $course['course_id']; ?>">
                                                            <?php echo htmlspecialchars($course['title']); ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="videoDescription" class="form-label">Description</label>
                                        <textarea class="form-control" id="videoDescription" name="description" rows="4"></textarea>
                                    </div>

                                    <!-- Thumbnail Upload -->
                                    <div class="mb-3">
                                        <label for="thumbnailFile" class="form-label">Thumbnail (Optional)</label>
                                        <input type="file" class="form-control" id="thumbnailFile" name="thumbnail" accept="image/*">
                                        <div class="form-text">Upload a custom thumbnail image (recommended: 1280x720)</div>
                                        <div id="thumbnailPreview" class="mt-2" style="display: none;">
                                            <img id="thumbnailImg" class="thumbnail-preview" alt="Thumbnail preview">
                                        </div>
                                    </div>

                                    <!-- Additional Settings -->
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="moduleOrder" class="form-label">Module Order</label>
                                                <input type="number" class="form-control" id="moduleOrder" name="module_order" min="1" value="1">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="videoPrice" class="form-label">Price (USD)</label>
                                                <input type="number" class="form-control" id="videoPrice" name="price" min="0" step="0.01" value="0">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="categoryName" class="form-label">Category</label>
                                                <input type="text" class="form-control" id="categoryName" name="category_name" placeholder="e.g., Programming, Design">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label">Visibility</label>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="is_published" id="published" value="1" checked>
                                                    <label class="form-check-label" for="published">Published</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="is_published" id="draft" value="0">
                                                    <label class="form-check-label" for="draft">Draft</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="isFree" name="is_free" value="1">
                                            <label class="form-check-label" for="isFree">
                                                This video is free to watch
                                            </label>
                                        </div>
                                    </div>

                                    <!-- Submit Button -->
                                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                        <button type="button" class="btn btn-secondary me-md-2" id="resetBtn">
                                            <i class="fas fa-undo"></i> Reset
                                        </button>
                                        <button type="submit" class="btn btn-primary" id="submitBtn">
                                            <i class="fas fa-cloud-upload-alt"></i> Upload Video
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Upload Tips -->
                    <div class="col-lg-4">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="card-title mb-0">Upload Tips</h6>
                            </div>
                            <div class="card-body">
                                <ul class="list-unstyled">
                                    <li><i class="fas fa-check text-success"></i> Supported formats: MP4, WebM, MOV, AVI</li>
                                    <li><i class="fas fa-check text-success"></i> No file size limit</li>
                                    <li><i class="fas fa-check text-success"></i> Recommended resolution: 1080p or higher</li>
                                    <li><i class="fas fa-check text-success"></i> Custom thumbnails improve engagement</li>
                                    <li><i class="fas fa-check text-success"></i> Clear titles help with discovery</li>
                                </ul>
                            </div>
                        </div>

                        <div class="card mt-3">
                            <div class="card-header">
                                <h6 class="card-title mb-0">Upload Status</h6>
                            </div>
                            <div class="card-body">
                                <div id="uploadStatusCard">
                                    <p class="text-muted">No upload in progress</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    <script src="video-upload.js"></script>
</body>
</html>
