<?php
// Display all PHP errors
ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "<h1>PHP Upload Test</h1>";

// Show PHP upload configuration
echo "<h2>PHP Upload Settings</h2>";
echo "<pre>";
echo "PHP Version: " . phpversion() . "\n";
echo "upload_max_filesize: " . ini_get('upload_max_filesize') . "\n";
echo "post_max_size: " . ini_get('post_max_size') . "\n";
echo "max_file_uploads: " . ini_get('max_file_uploads') . "\n";
echo "max_input_time: " . ini_get('max_input_time') . "\n";
echo "memory_limit: " . ini_get('memory_limit') . "\n";
echo "</pre>";

// Check if form was submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<h2>Upload Results</h2>";
    
    if (isset($_FILES['test_file'])) {
        $file = $_FILES['test_file'];
        
        echo "<pre>";
        echo "File name: " . htmlspecialchars($file['name']) . "\n";
        echo "File size: " . $file['size'] . " bytes\n";
        echo "File type: " . $file['type'] . "\n";
        echo "Error code: " . $file['error'] . "\n";
        
        // Translate error code
        $error_messages = array(
            UPLOAD_ERR_OK => 'No error, file uploaded successfully',
            UPLOAD_ERR_INI_SIZE => 'The uploaded file exceeds the upload_max_filesize directive in php.ini',
            UPLOAD_ERR_FORM_SIZE => 'The uploaded file exceeds the MAX_FILE_SIZE directive in the form',
            UPLOAD_ERR_PARTIAL => 'The uploaded file was only partially uploaded',
            UPLOAD_ERR_NO_FILE => 'No file was uploaded',
            UPLOAD_ERR_NO_TMP_DIR => 'Missing a temporary folder',
            UPLOAD_ERR_CANT_WRITE => 'Failed to write file to disk',
            UPLOAD_ERR_EXTENSION => 'A PHP extension stopped the file upload'
        );
        
        echo "Error message: " . ($error_messages[$file['error']] ?? 'Unknown error') . "\n";
        echo "</pre>";
        
        // If upload successful, show details
        if ($file['error'] === UPLOAD_ERR_OK) {
            echo "<p style='color: green;'>File uploaded successfully!</p>";
            echo "<p>Temporary file path: " . $file['tmp_name'] . "</p>";
        }
    } else {
        echo "<p>No file was submitted</p>";
    }
}

// Simple upload form
echo "<h2>Test Upload Form</h2>";
echo "<form method='POST' enctype='multipart/form-data'>";
echo "  <p>Select a small file to test uploads:</p>";
echo "  <input type='file' name='test_file' required>";
echo "  <br><br>";
echo "  <button type='submit'>Upload Test File</button>";
echo "</form>";

echo "<h2>PHP Information Summary</h2>";
echo "<p>Loaded php.ini: " . php_ini_loaded_file() . "</p>";

// Show the current working directory
echo "<p>Current working directory: " . getcwd() . "</p>";

// Check if upload directory is writable
$upload_dir = "../uploads/";
echo "<p>Upload directory (" . realpath($upload_dir) . ") is " . 
     (is_writable($upload_dir) ? "writable" : "NOT writable") . "</p>";

// Check temporary directory
$tmp_dir = sys_get_temp_dir();
echo "<p>Temporary directory (" . $tmp_dir . ") is " . 
     (is_writable($tmp_dir) ? "writable" : "NOT writable") . "</p>";
?>
