<?php
session_start();
require_once 'includes/db_connection.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teaching Tools - Panadite Academy</title>
    <meta name="description" content="Discover powerful teaching tools and resources to create engaging courses and enhance your teaching experience at Panadite Academy.">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-blue: #276BE4;
            --primary-amber: #FFA915;
            --dark-text: #2d3748;
            --light-text: #718096;
            --bg-light: #f8fafc;
            --border-color: #e2e8f0;
            --purple: #8b5cf6;
            --cyan: #06b6d4;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: var(--dark-text);
            background-color: var(--bg-light);
        }
        
        .hero-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            color: var(--dark-text);
            padding: 4rem 0 3rem;
            margin-bottom: 3rem;
            border-bottom: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 30% 70%, rgba(124, 58, 237, 0.04) 0%, transparent 50%),
                radial-gradient(circle at 70% 30%, rgba(39, 107, 228, 0.04) 0%, transparent 50%);
            animation: backgroundPulse 8s ease-in-out infinite alternate;
        }
        
        @keyframes backgroundPulse {
            0% { opacity: 0.3; }
            100% { opacity: 0.8; }
        }
        
        .floating-element {
            position: absolute;
            pointer-events: none;
            opacity: 0.1;
        }
        
        .floating-element:nth-child(1) {
            top: 18%;
            left: 12%;
            animation: float1 6s ease-in-out infinite;
        }
        
        .floating-element:nth-child(2) {
            top: 55%;
            right: 8%;
            animation: float2 8s ease-in-out infinite reverse;
        }
        
        .floating-element:nth-child(3) {
            bottom: 30%;
            left: 78%;
            animation: float3 7s ease-in-out infinite;
        }
        
        @keyframes float1 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(28px, -18px) rotate(180deg); }
        }
        
        @keyframes float2 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(-22px, -28px) rotate(-180deg); }
        }
        
        @keyframes float3 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(18px, 22px) rotate(360deg); }
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
            animation: fadeInUp 1s ease-out;
        }
        
        .hero-content h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            line-height: 1.2;
            color: var(--dark-text);
            animation: fadeInUp 1s ease-out 0.2s both;
        }
        
        .hero-content p {
            font-size: 1.1rem;
            color: var(--light-text);
            margin-bottom: 2rem;
            max-width: 600px;
            line-height: 1.6;
            animation: fadeInUp 1s ease-out 0.4s both;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .content-section {
            background: white;
            border-radius: 16px;
            padding: 3rem;
            margin-bottom: 2rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--border-color);
        }
        
        .section-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--dark-text);
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            background: linear-gradient(135deg, var(--purple), #7c3aed);
            color: white;
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            font-size: 1.25rem;
        }
        
        .tools-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin-top: 2rem;
        }
        
        .tool-card {
            background: white;
            border: 1px solid var(--border-color);
            border-radius: 16px;
            padding: 2rem;
            transition: all 0.3s ease;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .tool-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--primary-blue), var(--primary-amber));
            border-radius: 16px 16px 0 0;
        }
        
        .tool-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.1);
        }
        
        .tool-icon {
            width: 70px;
            height: 70px;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            font-size: 1.75rem;
            color: white;
        }
        
        .tool-icon.video { background: linear-gradient(135deg, #ef4444, #dc2626); }
        .tool-icon.design { background: linear-gradient(135deg, var(--primary-amber), #f59e0b); }
        .tool-icon.interactive { background: linear-gradient(135deg, var(--primary-blue), #1e5bcc); }
        .tool-icon.analytics { background: linear-gradient(135deg, var(--purple), #7c3aed); }
        .tool-icon.communication { background: linear-gradient(135deg, #10b981, #059669); }
        .tool-icon.productivity { background: linear-gradient(135deg, var(--cyan), #0891b2); }
        
        .tool-title {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--dark-text);
            margin-bottom: 0.75rem;
        }
        
        .tool-description {
            color: var(--light-text);
            font-size: 0.95rem;
            line-height: 1.6;
            margin-bottom: 1.5rem;
        }
        
        .tool-features {
            list-style: none;
            padding: 0;
            margin-bottom: 1.5rem;
            text-align: left;
        }
        
        .tool-features li {
            padding: 0.5rem 0;
            color: var(--light-text);
            font-size: 0.9rem;
            display: flex;
            align-items: center;
        }
        
        .tool-features li i {
            color: #10b981;
            margin-right: 0.75rem;
            font-size: 0.8rem;
        }
        
        .tool-btn {
            background: linear-gradient(135deg, var(--primary-blue), #1e5bcc);
            color: white;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            font-size: 0.9rem;
            display: inline-block;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
        }
        
        .tool-btn:hover {
            background: linear-gradient(135deg, #1e5bcc, var(--primary-blue));
            color: white;
            transform: translateY(-1px);
        }
        
        .category-nav {
            display: flex;
            justify-content: center;
            gap: 1rem;
            margin-bottom: 3rem;
            flex-wrap: wrap;
        }
        
        .category-btn {
            background: white;
            border: 2px solid var(--border-color);
            color: var(--dark-text);
            padding: 0.75rem 1.5rem;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .category-btn.active,
        .category-btn:hover {
            background: var(--primary-blue);
            border-color: var(--primary-blue);
            color: white;
        }
        
        .integration-section {
            background: linear-gradient(135deg, var(--bg-light) 0%, #e2e8f0 100%);
            border-radius: 16px;
            padding: 3rem;
            text-align: center;
            margin-top: 2rem;
        }
        
        .integration-icons {
            display: flex;
            justify-content: center;
            gap: 2rem;
            margin: 2rem 0;
            flex-wrap: wrap;
        }
        
        .integration-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: white;
            opacity: 0.8;
            transition: all 0.3s ease;
        }
        
        .integration-icon:hover {
            opacity: 1;
            transform: scale(1.1);
        }
        
        .back-btn {
            background: white;
            color: var(--primary-blue);
            border: 1px solid var(--border-color);
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            margin-bottom: 2rem;
        }
        
        .back-btn:hover {
            background: var(--bg-light);
            border-color: var(--primary-blue);
            color: var(--primary-blue);
        }
        
        .back-btn i {
            margin-right: 0.5rem;
        }
        
        .cta-section {
            background: linear-gradient(135deg, var(--primary-blue), #1e5bcc);
            color: white;
            border-radius: 16px;
            padding: 3rem;
            text-align: center;
            margin-top: 3rem;
        }
        
        .cta-section h2 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 1rem;
        }
        
        .cta-section p {
            font-size: 1.1rem;
            opacity: 0.9;
            margin-bottom: 2rem;
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .btn-get-started {
            background: white;
            color: var(--primary-blue);
            padding: 1rem 2rem;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 700;
            font-size: 1.1rem;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }
        
        .btn-get-started:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            color: var(--primary-blue);
        }
        
        .btn-get-started i {
            margin-left: 0.5rem;
        }
    </style>
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    
    <!-- Hero Section -->
    <section class="hero-section">
        <!-- Floating animated elements -->
        <div class="floating-element">
            <i class="fas fa-tools" style="font-size: 48px; color: var(--purple);"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-cogs" style="font-size: 52px; color: var(--primary-blue);"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-rocket" style="font-size: 40px; color: var(--primary-amber);"></i>
        </div>
        
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1>Teaching Tools</h1>
                        <p>Discover powerful tools and resources to create engaging courses, enhance your teaching experience, and help your students succeed with professional-grade educational technology.</p>
                    </div>
                </div>
                <div class="col-lg-4 text-center">
                    <div style="background: white; border-radius: 16px; padding: 2rem; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08); border: 1px solid var(--border-color);">
                        <i class="fas fa-tools" style="font-size: 3rem; margin-bottom: 1rem; color: var(--purple);"></i>
                        <h4 style="margin: 0; font-weight: 700; color: var(--dark-text);">Pro Tools</h4>
                        <p style="margin: 0.5rem 0 0; color: var(--light-text); font-size: 0.95rem;">Create Better Courses</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <div class="container">
        <a href="index.php" class="back-btn">
            <i class="fas fa-arrow-left"></i>
            Back to Home
        </a>
        
        <!-- Category Navigation -->
        <div class="category-nav">
            <button class="category-btn active" onclick="showCategory('all')">All Tools</button>
            <button class="category-btn" onclick="showCategory('video')">Video & Recording</button>
            <button class="category-btn" onclick="showCategory('design')">Design & Graphics</button>
            <button class="category-btn" onclick="showCategory('interactive')">Interactive Content</button>
            <button class="category-btn" onclick="showCategory('analytics')">Analytics</button>
        </div>
        
        <!-- Video & Recording Tools -->
        <div class="content-section" data-category="video">
            <h2 class="section-title">
                <i class="fas fa-video"></i>
                Video & Recording Tools
            </h2>
            <div class="tools-grid">
                <div class="tool-card">
                    <div class="tool-icon video">
                        <i class="fas fa-video"></i>
                    </div>
                    <h3 class="tool-title">Course Video Recorder</h3>
                    <p class="tool-description">Built-in recording studio with professional features for creating high-quality course content.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>HD screen recording</li>
                        <li><i class="fas fa-check"></i>Webcam integration</li>
                        <li><i class="fas fa-check"></i>Audio noise reduction</li>
                        <li><i class="fas fa-check"></i>Auto-sync captions</li>
                    </ul>
                    <button class="tool-btn">Start Recording</button>
                </div>
                
                <div class="tool-card">
                    <div class="tool-icon video">
                        <i class="fas fa-cut"></i>
                    </div>
                    <h3 class="tool-title">Video Editor</h3>
                    <p class="tool-description">Simple yet powerful video editing tools to polish your course content.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>Trim and cut videos</li>
                        <li><i class="fas fa-check"></i>Add transitions</li>
                        <li><i class="fas fa-check"></i>Insert text overlays</li>
                        <li><i class="fas fa-check"></i>Background music</li>
                    </ul>
                    <button class="tool-btn">Edit Videos</button>
                </div>
                
                <div class="tool-card">
                    <div class="tool-icon video">
                        <i class="fas fa-microphone"></i>
                    </div>
                    <h3 class="tool-title">Audio Enhancer</h3>
                    <p class="tool-description">Professional audio processing to ensure crystal-clear sound quality.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>Noise cancellation</li>
                        <li><i class="fas fa-check"></i>Volume normalization</li>
                        <li><i class="fas fa-check"></i>Echo removal</li>
                        <li><i class="fas fa-check"></i>Audio compression</li>
                    </ul>
                    <button class="tool-btn">Enhance Audio</button>
                </div>
            </div>
        </div>
        
        <!-- Design & Graphics Tools -->
        <div class="content-section" data-category="design">
            <h2 class="section-title">
                <i class="fas fa-palette"></i>
                Design & Graphics Tools
            </h2>
            <div class="tools-grid">
                <div class="tool-card">
                    <div class="tool-icon design">
                        <i class="fas fa-presentation"></i>
                    </div>
                    <h3 class="tool-title">Slide Creator</h3>
                    <p class="tool-description">Create beautiful, professional slides with our easy-to-use design tools.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>Professional templates</li>
                        <li><i class="fas fa-check"></i>Drag-and-drop editor</li>
                        <li><i class="fas fa-check"></i>Brand color schemes</li>
                        <li><i class="fas fa-check"></i>Animation effects</li>
                    </ul>
                    <button class="tool-btn">Create Slides</button>
                </div>
                
                <div class="tool-card">
                    <div class="tool-icon design">
                        <i class="fas fa-image"></i>
                    </div>
                    <h3 class="tool-title">Course Thumbnails</h3>
                    <p class="tool-description">Generate eye-catching course thumbnails that attract students and boost enrollment.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>AI-powered designs</li>
                        <li><i class="fas fa-check"></i>Multiple size formats</li>
                        <li><i class="fas fa-check"></i>Brand consistency</li>
                        <li><i class="fas fa-check"></i>A/B testing support</li>
                    </ul>
                    <button class="tool-btn">Create Thumbnails</button>
                </div>
                
                <div class="tool-card">
                    <div class="tool-icon design">
                        <i class="fas fa-chart-pie"></i>
                    </div>
                    <h3 class="tool-title">Infographic Maker</h3>
                    <p class="tool-description">Transform complex information into engaging visual infographics.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>Data visualization</li>
                        <li><i class="fas fa-check"></i>Interactive charts</li>
                        <li><i class="fas fa-check"></i>Export to multiple formats</li>
                        <li><i class="fas fa-check"></i>Collaborative editing</li>
                    </ul>
                    <button class="tool-btn">Make Infographics</button>
                </div>
            </div>
        </div>
        
        <!-- Interactive Content Tools -->
        <div class="content-section" data-category="interactive">
            <h2 class="section-title">
                <i class="fas fa-gamepad"></i>
                Interactive Content Tools
            </h2>
            <div class="tools-grid">
                <div class="tool-card">
                    <div class="tool-icon interactive">
                        <i class="fas fa-question-circle"></i>
                    </div>
                    <h3 class="tool-title">Quiz Builder</h3>
                    <p class="tool-description">Create engaging quizzes and assessments to test student knowledge.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>Multiple question types</li>
                        <li><i class="fas fa-check"></i>Automatic grading</li>
                        <li><i class="fas fa-check"></i>Instant feedback</li>
                        <li><i class="fas fa-check"></i>Progress tracking</li>
                    </ul>
                    <button class="tool-btn">Build Quizzes</button>
                </div>
                
                <div class="tool-card">
                    <div class="tool-icon interactive">
                        <i class="fas fa-clipboard-list"></i>
                    </div>
                    <h3 class="tool-title">Assignment Creator</h3>
                    <p class="tool-description">Design practical assignments and projects for hands-on learning.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>File upload support</li>
                        <li><i class="fas fa-check"></i>Rubric-based grading</li>
                        <li><i class="fas fa-check"></i>Peer review system</li>
                        <li><i class="fas fa-check"></i>Deadline management</li>
                    </ul>
                    <button class="tool-btn">Create Assignments</button>
                </div>
                
                <div class="tool-card">
                    <div class="tool-icon interactive">
                        <i class="fas fa-poll"></i>
                    </div>
                    <h3 class="tool-title">Live Polls</h3>
                    <p class="tool-description">Engage students with real-time polls and interactive discussions.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>Real-time responses</li>
                        <li><i class="fas fa-check"></i>Anonymous voting</li>
                        <li><i class="fas fa-check"></i>Result visualization</li>
                        <li><i class="fas fa-check"></i>Export data</li>
                    </ul>
                    <button class="tool-btn">Create Polls</button>
                </div>
            </div>
        </div>
        
        <!-- Analytics Tools -->
        <div class="content-section" data-category="analytics">
            <h2 class="section-title">
                <i class="fas fa-chart-line"></i>
                Analytics & Insights
            </h2>
            <div class="tools-grid">
                <div class="tool-card">
                    <div class="tool-icon analytics">
                        <i class="fas fa-analytics"></i>
                    </div>
                    <h3 class="tool-title">Course Analytics</h3>
                    <p class="tool-description">Get detailed insights into course performance and student engagement.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>Enrollment tracking</li>
                        <li><i class="fas fa-check"></i>Completion rates</li>
                        <li><i class="fas fa-check"></i>Revenue analytics</li>
                        <li><i class="fas fa-check"></i>Student feedback analysis</li>
                    </ul>
                    <button class="tool-btn">View Analytics</button>
                </div>
                
                <div class="tool-card">
                    <div class="tool-icon analytics">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3 class="tool-title">Student Insights</h3>
                    <p class="tool-description">Understand your students better with comprehensive behavioral analytics.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>Learning patterns</li>
                        <li><i class="fas fa-check"></i>Engagement metrics</li>
                        <li><i class="fas fa-check"></i>Drop-off points</li>
                        <li><i class="fas fa-check"></i>Success predictions</li>
                    </ul>
                    <button class="tool-btn">Analyze Students</button>
                </div>
                
                <div class="tool-card">
                    <div class="tool-icon analytics">
                        <i class="fas fa-trophy"></i>
                    </div>
                    <h3 class="tool-title">Performance Dashboard</h3>
                    <p class="tool-description">Monitor your teaching performance with comprehensive dashboards.</p>
                    <ul class="tool-features">
                        <li><i class="fas fa-check"></i>Teaching metrics</li>
                        <li><i class="fas fa-check"></i>Student satisfaction</li>
                        <li><i class="fas fa-check"></i>Course ratings</li>
                        <li><i class="fas fa-check"></i>Goal tracking</li>
                    </ul>
                    <button class="tool-btn">View Dashboard</button>
                </div>
            </div>
        </div>
        
        <!-- Integration Section -->
        <div class="integration-section">
            <h3 style="font-size: 1.5rem; font-weight: 700; margin-bottom: 1rem;">Seamless Integrations</h3>
            <p style="color: var(--light-text); margin-bottom: 2rem;">Connect your favorite tools and platforms for a streamlined teaching experience.</p>
            <div class="integration-icons">
                <div class="integration-icon" style="background: #4285f4;"><i class="fab fa-google"></i></div>
                <div class="integration-icon" style="background: #0078d4;"><i class="fab fa-microsoft"></i></div>
                <div class="integration-icon" style="background: #007acc;"><i class="fab fa-dropbox"></i></div>
                <div class="integration-icon" style="background: #ff6900;"><i class="fab fa-soundcloud"></i></div>
                <div class="integration-icon" style="background: #ff0000;"><i class="fab fa-youtube"></i></div>
                <div class="integration-icon" style="background: #6cc04a;"><i class="fab fa-spotify"></i></div>
            </div>
        </div>
        
        <!-- Call to Action -->
        <div class="cta-section">
            <h2>Start Using These Tools Today</h2>
            <p>Join thousands of instructors who are already using our powerful tools to create amazing courses and grow their teaching business.</p>
            <a href="auth/register.php" class="btn-get-started">
                Get Started as Instructor
                <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        function showCategory(category) {
            // Remove active class from all buttons
            document.querySelectorAll('.category-btn').forEach(btn => {
                btn.classList.remove('active');
            });
            
            // Add active class to clicked button
            event.target.classList.add('active');
            
            // Show/hide sections based on category
            const sections = document.querySelectorAll('[data-category]');
            sections.forEach(section => {
                if (category === 'all' || section.getAttribute('data-category') === category) {
                    section.style.display = 'block';
                } else {
                    section.style.display = 'none';
                }
            });
        }
    </script>
</body>
</html>
